/*
 * Decompiled with CFR 0.152.
 */
package jd.utils;

import java.io.File;
import jd.controlling.JDLogger;
import jd.nutils.OSDetector;
import jd.utils.JDUtilities;

public class GetExplorer {
    private Object[] explorer = (Object[])JDUtilities.getConfiguration().getProperty("PARAM_FILE_BROWSER", null);

    private static Object[] autoGetExplorerCommand() {
        if (OSDetector.isWindows()) {
            return new Object[]{"Explorer", "explorer", new String[]{"%%path%%"}};
        }
        if (OSDetector.isMac()) {
            return new Object[]{"Open", "/usr/bin/open", new String[]{"%%path%%"}};
        }
        Object[][] programms = new Object[][]{{"dolphin", new String[]{"%%path%%"}}, {"konqueror", new String[]{"%%path%%"}}, {"nautilus", new String[]{"--browser", "--no-desktop", "%%path%%"}}};
        try {
            String[] charset;
            String[] stringArray = charset = System.getenv("PATH").split(":");
            int n = charset.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                Object[][] objectArrayArray = programms;
                int n3 = programms.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object[] element2 = objectArrayArray[n4];
                    File fi = new File(element, (String)element2[0]);
                    if (fi.isFile()) {
                        return new Object[]{(String)element2[0], fi.getAbsolutePath(), element2[1]};
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public Object[] getExplorerCommand() {
        if (this.explorer != null) {
            if (!new File((String)this.explorer[1]).exists()) {
                this.explorer = null;
            }
            JDUtilities.getConfiguration().setProperty("PARAM_FILE_BROWSER", null);
        }
        if (this.explorer == null) {
            this.explorer = GetExplorer.autoGetExplorerCommand();
            if (this.explorer == null) {
                JDLogger.getLogger().severe("Can't find explorer command");
            } else {
                JDUtilities.getConfiguration().setProperty("PARAM_FILE_BROWSER", this.explorer);
            }
        }
        return this.explorer;
    }

    public boolean openExplorer(File path) {
        if (path == null) {
            return false;
        }
        this.getExplorerCommand();
        while (path != null && !path.isDirectory()) {
            path = path.getParentFile();
        }
        if (path != null && this.explorer != null) {
            String spath = path.getAbsolutePath();
            String[] paramsArray = (String[])this.explorer[2];
            String[] finalParams = new String[paramsArray.length];
            int i = 0;
            while (i < paramsArray.length) {
                finalParams[i] = paramsArray[i].replace("%%path%%", spath);
                ++i;
            }
            JDUtilities.runCommand((String)this.explorer[1], finalParams, null, 0);
            return true;
        }
        return false;
    }
}

