/*
 * Decompiled with CFR 0.152.
 */
package jd.utils;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import jd.config.SubConfiguration;
import jd.controlling.JDLogger;
import jd.gui.UserIO;
import jd.gui.swing.GuiRunnable;
import jd.gui.swing.dialog.AbstractDialog;
import jd.gui.swing.dialog.ContainerDialog;
import jd.nutils.JDImage;
import jd.nutils.OSDetector;
import jd.nutils.io.JDIO;
import jd.utils.JDTheme;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;
import net.miginfocom.swing.MigLayout;

public class JDFileReg {
    public static String createSetKey(String key, String valueName, String value) {
        StringBuilder sb = new StringBuilder();
        sb.append("\r\n[HKEY_CLASSES_ROOT\\" + key + "]");
        if (valueName != null && valueName.trim().length() > 0) {
            sb.append("\r\n\"" + valueName + "\"=\"" + value + "\"");
        } else {
            sb.append("\r\n@=\"" + value + "\"");
        }
        return sb.toString();
    }

    public static void unregisterFileExts() {
        JDUtilities.runCommand("cmd", new String[]{"/c", "regedit", "/S", JDUtilities.getResourceFile("tools/windows/uninstall.reg").getAbsolutePath()}, JDUtilities.getResourceFile("tmp").getAbsolutePath(), 600);
    }

    public static void registerFileExts() {
        if (!OSDetector.isWindows()) {
            return;
        }
        if (!SubConfiguration.getConfig("CNL2").getBooleanProperty("INSTALLED", false).booleanValue()) {
            StringBuilder sb = new StringBuilder();
            sb.append(JDFileReg.createRegisterWinFileExt("jd"));
            sb.append(JDFileReg.createRegisterWinFileExt("dlc"));
            sb.append(JDFileReg.createRegisterWinFileExt("metalink"));
            sb.append(JDFileReg.createRegisterWinFileExt("ccf"));
            sb.append(JDFileReg.createRegisterWinFileExt("rsdf"));
            sb.append(JDFileReg.createRegisterWinProtocol("jd"));
            sb.append(JDFileReg.createRegisterWinProtocol("jdlist"));
            sb.append(JDFileReg.createRegisterWinProtocol("dlc"));
            sb.append(JDFileReg.createRegisterWinProtocol("metalink"));
            sb.append(JDFileReg.createRegisterWinProtocol("ccf"));
            sb.append(JDFileReg.createRegisterWinProtocol("rsdf"));
            AbstractDialog.setDefaultDimension((Dimension)new Dimension(550, 400));
            JDIO.writeLocalFile(JDUtilities.getResourceFile("tmp/installcnl.reg"), "Windows Registry Editor Version 5.00\r\n\r\n\r\n\r\n" + sb.toString());
            int answer = JDFileReg.showQuestion();
            if ((answer & 2) > 0) {
                JDUtilities.runCommand("cmd", new String[]{"/c", "regedit", JDUtilities.getResourceFile("tmp/installcnl.reg").getAbsolutePath()}, JDUtilities.getResourceFile("tmp").getAbsolutePath(), 600);
                JDUtilities.runCommand("cmd", new String[]{"/c", "regedit", "/e", JDUtilities.getResourceFile("tmp/test.reg").getAbsolutePath(), "HKEY_CLASSES_ROOT\\.dlc"}, JDUtilities.getResourceFile("tmp").getAbsolutePath(), 600);
                if (JDUtilities.getResourceFile("tmp/test.reg").exists()) {
                    JDLogger.getLogger().info("Installed Click'n'Load and associated .*dlc,.*ccf,.*rsdf and .*jd with JDownloader. Uninstall with " + JDUtilities.getResourceFile("tools/windows/uninstall.reg"));
                } else {
                    UserIO.getInstance().requestConfirmDialog(16, JDL.L((String)"gui.cnl.install.error.title", (String)"Click'n'Load Installation"), JDL.LF((String)"gui.cnl.install.error.message", (String)"Installation of CLick'n'Load failed. Try these alternatives:\r\n * Start JDownloader as Admin.\r\n * Try to execute %s manually.\r\n * Open Configuration->General->Click'n'load-> [Install].\r\nFor details, visit http://jdownloader.org/click-n-load.", (Object[])new Object[]{JDUtilities.getResourceFile("tmp/installcnl.reg").getAbsolutePath()}), JDTheme.II("gui.clicknload", 48, 48), null, null);
                    JDLogger.getLogger().severe("Installation of CLick'n'Load failed. Please try to start JDownloader as Admin. For details, visit http://jdownloader.org/click-n-load. Try to execute " + JDUtilities.getResourceFile("tmp/installcnl.reg").getAbsolutePath() + " manually");
                }
            }
            SubConfiguration.getConfig("CNL2").setProperty("INSTALLED", true);
            SubConfiguration.getConfig("CNL2").save();
        }
        JDUtilities.getResourceFile("tmp/test.reg").delete();
    }

    private static int showQuestion() {
        return (Integer)new GuiRunnable<Object>(){
            private ContainerDialog dialog;

            public Object runSave() {
                JPanel c = new JPanel((LayoutManager)new MigLayout("ins 10,wrap 1", "[grow,fill]", "[][][grow,fill]"));
                JLabel lbl = new JLabel(JDL.L((String)"installer.gui.message", (String)"After Installation, JDownloader will update to the latest version."));
                if (OSDetector.isWindows()) {
                    JDUtilities.getResourceFile("downloads");
                }
                c.add((Component)lbl, "pushx,growx,split 2");
                Font f = lbl.getFont();
                f = f.deriveFont(f.getStyle() ^ 1);
                lbl.setFont(f);
                c.add((Component)new JLabel(JDTheme.II("gui.clicknload", 48, 48)), "alignx right");
                c.add((Component)new JSeparator(), "pushx,growx,gapbottom 5");
                JTextArea txt = new JTextArea();
                c.add((Component)txt, "growy,pushy");
                txt.setText(JDL.L((String)"gui.cnl.install.text", (String)"Click'n'load is a very comfortable way to add links to JDownloader. \r\nTo install Click'n'Load, JDownloader has to set some registry entries. \r\nYou might have to confirm some Windows messages to continue."));
                txt.setLineWrap(true);
                txt.setBorder(null);
                txt.setOpaque(false);
                txt.putClientProperty("Synthetica.opaque", Boolean.FALSE);
                new ContainerDialog(4, JDL.L((String)"gui.cnl.install.title", (String)"Click'n'Load Installation"), c, null, null){
                    private static final long serialVersionUID = 6102497815556948120L;

                    protected void packed() {
                        dialog = this;
                        this.setIconImage(JDImage.getImage("logo/jd_logo_54_54"));
                        this.setSize(550, 400);
                    }

                    protected void setReturnValue(boolean b) {
                        super.setReturnValue(b);
                    }
                };
                return this.dialog.getReturnValue();
            }
        }.getReturnValue();
    }

    private static String createRegisterWinFileExt(String ext) {
        String command = String.valueOf(JDUtilities.getResourceFile("JDownloader.exe").getAbsolutePath().replace("\\", "\\\\")) + " \\\"%1\\\"";
        StringBuilder sb = new StringBuilder();
        sb.append("\r\n\r\n;Register fileextension ." + ext);
        sb.append(JDFileReg.createSetKey("." + ext, "", "JDownloader " + ext + " file"));
        sb.append(JDFileReg.createSetKey("JDownloader " + ext + " file" + "\\shell", "", "open"));
        sb.append(JDFileReg.createSetKey("JDownloader " + ext + " file" + "\\DefaultIcon", "", JDUtilities.getResourceFile("JDownloader.exe").getAbsolutePath().replace("\\", "\\\\")));
        sb.append(JDFileReg.createSetKey("JDownloader " + ext + " file" + "\\shell\\open\\command", "", command));
        return sb.toString();
    }

    private static String createRegisterWinProtocol(String p) {
        String command = String.valueOf(JDUtilities.getResourceFile("JDownloader.exe").getAbsolutePath().replace("\\", "\\\\")) + " --add-link \\\"%1\\\"";
        StringBuilder sb = new StringBuilder();
        sb.append("\r\n\r\n;Register Protocol " + p + "://jdownloader.org/sample." + p);
        sb.append(JDFileReg.createSetKey(p, "", "JDownloader " + p));
        sb.append(JDFileReg.createSetKey(String.valueOf(p) + "\\DefaultIcon", "", JDUtilities.getResourceFile("JDownloader.exe").getAbsolutePath().replace("\\", "\\\\")));
        sb.append(JDFileReg.createSetKey(String.valueOf(p) + "\\shell", "", "open"));
        sb.append(JDFileReg.createSetKey(p, "Url Protocol", ""));
        sb.append(JDFileReg.createSetKey(String.valueOf(p) + "\\shell\\open\\command", "", command));
        return sb.toString();
    }
}

