/*
 * Decompiled with CFR 0.152.
 */
package jd.utils;

import java.util.HashMap;
import java.util.Map;
import jd.parser.Regex;

public class JDGeoCode {
    public static final HashMap<String, String[]> LANGUAGES = new HashMap();
    public static final HashMap<String, String> COUNTRIES;
    public static final HashMap<String, String> EXTENSIONS;

    static {
        LANGUAGES.put("aa", new String[]{"Afar", "Afaraf"});
        LANGUAGES.put("ab", new String[]{"Abkhazian", "\u0410\u04a7\u0441\u0443\u0430"});
        LANGUAGES.put("ae", new String[]{"Avestan", "avesta"});
        LANGUAGES.put("af", new String[]{"Afrikaans", "Afrikaans"});
        LANGUAGES.put("ak", new String[]{"Akan", "Akan"});
        LANGUAGES.put("am", new String[]{"Amharic", "\u12a0\u121b\u122d\u129b"});
        LANGUAGES.put("an", new String[]{"Aragonese", "Aragon\u00e9s"});
        LANGUAGES.put("ar", new String[]{"Arabic", "\u0627\u0644\u0639\u0631\u0628\u064a\u0629"});
        LANGUAGES.put("av", new String[]{"Avaric", "\u0430\u0432\u0430\u0440 \u043c\u0430\u0446\u04c0; \u043c\u0430\u0433\u04c0\u0430\u0440\u0443\u043b \u043c\u0430\u0446\u04c0"});
        LANGUAGES.put("ay", new String[]{"Aymara", "aymar aru"});
        LANGUAGES.put("az", new String[]{"Azerbaijani", "az\u0259rbaycan dili"});
        LANGUAGES.put("ba", new String[]{"Bashkir", "\u0431\u0430\u0448\u04a1\u043e\u0440\u0442 \u0442\u0435\u043b\u0435"});
        LANGUAGES.put("be", new String[]{"Belarusian", "\u0411\u0435\u043b\u0430\u0440\u0443\u0441\u043a\u0430\u044f"});
        LANGUAGES.put("bg", new String[]{"Bulgarian", "\u0431\u044a\u043b\u0433\u0430\u0440\u0441\u043a\u0438 \u0435\u0437\u0438\u043a"});
        LANGUAGES.put("bh", new String[]{"Bihari", "\u092d\u094b\u091c\u092a\u0941\u0930\u0940"});
        LANGUAGES.put("bm", new String[]{"Bambara", "bamanankan"});
        LANGUAGES.put("bn", new String[]{"Bengali", "\u09ac\u09be\u0982\u09b2\u09be"});
        LANGUAGES.put("bo", new String[]{"Tibetan", "\u0f56\u0f7c\u0f51\u0f0b\u0f61\u0f72\u0f42"});
        LANGUAGES.put("br", new String[]{"Breton", "brezhoneg"});
        LANGUAGES.put("bs", new String[]{"Bosnian", "bosanski jezik"});
        LANGUAGES.put("ca", new String[]{"Catalan", "Catal\u00e0"});
        LANGUAGES.put("ch", new String[]{"Chamorro", "Chamoru"});
        LANGUAGES.put("co", new String[]{"Corsican", "corsu; lingua corsa"});
        LANGUAGES.put("cr", new String[]{"Cree", "\u14c0\u1426\u1403\u152d\u140d\u140f\u1423"});
        LANGUAGES.put("cs", new String[]{"Czech", "\u010desky; \u010de\u0161tina"});
        LANGUAGES.put("cu", new String[]{"Church Slavic", "\u0469\u0437\u044b\u043a\u044a \u0441\u043b\u043e\u0432\u0463\u043d\u044c\u0441\u043a\u044a"});
        LANGUAGES.put("cv", new String[]{"Chuvash", "\u0447\u04d1\u0432\u0430\u0448 \u0447\u04d7\u043b\u0445\u0438"});
        LANGUAGES.put("cy", new String[]{"Welsh", "Cymraeg"});
        LANGUAGES.put("da", new String[]{"Danish", "dansk"});
        LANGUAGES.put("de", new String[]{"German", "Deutsch"});
        LANGUAGES.put("dv", new String[]{"Divehi", "\u078b\u07a8\u0788\u07ac\u0780\u07a8"});
        LANGUAGES.put("dz", new String[]{"Dzongkha", "\u0f62\u0fab\u0f7c\u0f44\u0f0b\u0f41"});
        LANGUAGES.put("ee", new String[]{"Ewe", "\u0190\u028b\u025bgb\u025b"});
        LANGUAGES.put("el", new String[]{"Greek", "\u0395\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac"});
        LANGUAGES.put("en", new String[]{"English", "English"});
        LANGUAGES.put("eo", new String[]{"Esperanto", "Esperanto"});
        LANGUAGES.put("es", new String[]{"Spanish", "Espa\u00f1ol"});
        LANGUAGES.put("et", new String[]{"Estonian", "eesti; eesti keel"});
        LANGUAGES.put("eu", new String[]{"Basque", "euskara; euskera"});
        LANGUAGES.put("fa", new String[]{"Persian", "\u0641\u0627\u0631\u0633\u06cc"});
        LANGUAGES.put("ff", new String[]{"Fulah", "Fulfulde"});
        LANGUAGES.put("fi", new String[]{"Finnish", "suomi; suomen kieli"});
        LANGUAGES.put("fj", new String[]{"Fijian", "vosa Vakaviti"});
        LANGUAGES.put("fo", new String[]{"Faroese", "F\u00f8royskt"});
        LANGUAGES.put("fr", new String[]{"French", "Fran\u00e7ais; langue fran\u00e7aise"});
        LANGUAGES.put("fy", new String[]{"Western Frisian", "Frysk"});
        LANGUAGES.put("ga", new String[]{"Irish", "Gaeilge"});
        LANGUAGES.put("gd", new String[]{"Scottish Gaelic", "G\u00e0idhlig"});
        LANGUAGES.put("gl", new String[]{"Galician", "Galego"});
        LANGUAGES.put("gn", new String[]{"Guaran\u00ed", "Ava\u00f1e'\u1ebd"});
        LANGUAGES.put("gu", new String[]{"Gujarati", "\u0a97\u0ac1\u0a9c\u0ab0\u0abe\u0aa4\u0ac0"});
        LANGUAGES.put("gv", new String[]{"Manx", "Gaelg; Gailck"});
        LANGUAGES.put("ha", new String[]{"Hausa", "\u0647\u064e\u0648\u064f\u0633\u064e"});
        LANGUAGES.put("he", new String[]{"Hebrew", "\u05e2\u05d1\u05e8\u05d9\u05ea"});
        LANGUAGES.put("hi", new String[]{"Hindi", "\u0939\u093f\u0928\u094d\u0926\u0940; \u0939\u093f\u0902\u0926\u0940"});
        LANGUAGES.put("ho", new String[]{"Hiri Motu", "Hiri Motu"});
        LANGUAGES.put("hr", new String[]{"Croatian", "Hrvatski"});
        LANGUAGES.put("ht", new String[]{"Haitian", "Krey\u00f2l ayisyen"});
        LANGUAGES.put("hu", new String[]{"Hungarian", "Magyar"});
        LANGUAGES.put("hy", new String[]{"Armenian", "\u0540\u0561\u0575\u0565\u0580\u0565\u0576"});
        LANGUAGES.put("hz", new String[]{"Herero", "Otjiherero"});
        LANGUAGES.put("ia", new String[]{"Interlingua (International Auxiliary Language Association)", "Interlingua"});
        LANGUAGES.put("id", new String[]{"Indonesian", "Bahasa Indonesia"});
        LANGUAGES.put("ie", new String[]{"Interlingue", "Interlingue"});
        LANGUAGES.put("ig", new String[]{"Igbo", "Igbo"});
        LANGUAGES.put("ii", new String[]{"Sichuan Yi", "\ua187\ua259"});
        LANGUAGES.put("ik", new String[]{"Inupiaq", "I\u00f1upiaq; I\u00f1upiatun"});
        LANGUAGES.put("io", new String[]{"Ido", "Ido"});
        LANGUAGES.put("is", new String[]{"Icelandic", "\u00cdslenska"});
        LANGUAGES.put("it", new String[]{"Italian", "Italiano"});
        LANGUAGES.put("iu", new String[]{"Inuktitut", "\u1403\u14c4\u1483\u144e\u1450\u1466"});
        LANGUAGES.put("ja", new String[]{"Japanese", "basa Jawa"});
        LANGUAGES.put("ka", new String[]{"Georgian", "\u10e5\u10d0\u10e0\u10d7\u10e3\u10da\u10d8"});
        LANGUAGES.put("kg", new String[]{"Kongo", "KiKongo"});
        LANGUAGES.put("ki", new String[]{"Kikuyu", "G\u0129k\u0169y\u0169"});
        LANGUAGES.put("kj", new String[]{"Kwanyama", "Kuanyama"});
        LANGUAGES.put("kk", new String[]{"Kazakh", "\u049a\u0430\u0437\u0430\u049b \u0442\u0456\u043b\u0456"});
        LANGUAGES.put("kl", new String[]{"Kalaallisut", "kalaallisut; kalaallit oqaasii"});
        LANGUAGES.put("km", new String[]{"Khmer", "\u1797\u17b6\u179f\u17b6\u1781\u17d2\u1798\u17c2\u179a"});
        LANGUAGES.put("kn", new String[]{"Kannada", "\u0c95\u0ca8\u0ccd\u0ca8\u0ca1"});
        LANGUAGES.put("ko", new String[]{"Korean", "Kanuri"});
        LANGUAGES.put("ks", new String[]{"Kashmiri", "\u043a\u043e\u043c\u0438 \u043a\u044b\u0432"});
        LANGUAGES.put("kw", new String[]{"Cornish", "Kernewek"});
        LANGUAGES.put("ky", new String[]{"Kirghiz", "\u043a\u044b\u0440\u0433\u044b\u0437 \u0442\u0438\u043b\u0438"});
        LANGUAGES.put("la", new String[]{"Latin", "latine; lingua latina"});
        LANGUAGES.put("lb", new String[]{"Luxembourgish", "L\u00ebtzebuergesch"});
        LANGUAGES.put("lg", new String[]{"Ganda", "Luganda"});
        LANGUAGES.put("li", new String[]{"Limburgish", "Limburgs"});
        LANGUAGES.put("ln", new String[]{"Lingala", "Ling\u00e1la"});
        LANGUAGES.put("lo", new String[]{"Lao", "\u0e9e\u0eb2\u0eaa\u0eb2\u0ea5\u0eb2\u0ea7"});
        LANGUAGES.put("lt", new String[]{"Lithuanian", "lietuvi\u0173 kalba"});
        LANGUAGES.put("lu", new String[]{"Luba-Katanga", "latvie\u0161u valoda"});
        LANGUAGES.put("mg", new String[]{"Malagasy", "Malagasy fiteny"});
        LANGUAGES.put("mh", new String[]{"Marshallese", "Kajin M\u0327aje\u013c"});
        LANGUAGES.put("mi", new String[]{"M\u0101ori", "te reo M\u0101ori"});
        LANGUAGES.put("mk", new String[]{"Macedonian", "\u043c\u0430\u043a\u0435\u0434\u043e\u043d\u0441\u043a\u0438 \u0458\u0430\u0437\u0438\u043a"});
        LANGUAGES.put("ml", new String[]{"Malayalam", "\u0d2e\u0d32\u0d2f\u0d3e\u0d33\u0d02"});
        LANGUAGES.put("mn", new String[]{"Mongolian", "\u041c\u043e\u043d\u0433\u043e\u043b"});
        LANGUAGES.put("mr", new String[]{"Marathi", "\u092e\u0930\u093e\u0920\u0940"});
        LANGUAGES.put("ms", new String[]{"Malay", "Malti"});
        LANGUAGES.put("my", new String[]{"Burmese", "\u1017\u1019\u102c\u1005\u102c"});
        LANGUAGES.put("na", new String[]{"Nauru", "Ekakair\u0169 Naoero"});
        LANGUAGES.put("nb", new String[]{"Norwegian Bokm\u00e5l", "Norsk bokm\u00e5l"});
        LANGUAGES.put("nd", new String[]{"North Ndebele", "isiNdebele"});
        LANGUAGES.put("ne", new String[]{"Nepali", "\u0928\u0947\u092a\u093e\u0932\u0940"});
        LANGUAGES.put("ng", new String[]{"Ndonga", "Owambo"});
        LANGUAGES.put("nl", new String[]{"Dutch", "Nederlands"});
        LANGUAGES.put("nn", new String[]{"Norwegian Nynorsk", "Norsk nynorsk"});
        LANGUAGES.put("no", new String[]{"Norwegian", "Norsk"});
        LANGUAGES.put("nr", new String[]{"South Ndebele", "isiNdebele"});
        LANGUAGES.put("nv", new String[]{"Navajo", "Din\u00e9 bizaad; Din\u00e9k\u02bceh\u01f0\u00ed"});
        LANGUAGES.put("ny", new String[]{"Chichewa", "chiChe\u0175a; chinyanja"});
        LANGUAGES.put("oc", new String[]{"Occitan", "Occitan"});
        LANGUAGES.put("oj", new String[]{"Ojibwa", "\u140a\u14c2\u1511\u14c8\u142f\u14a7\u140e\u14d0"});
        LANGUAGES.put("om", new String[]{"Oromo", "Afaan Oromoo"});
        LANGUAGES.put("or", new String[]{"Oriya", "\u0b13\u0b21\u0b3c\u0b3f\u0b06"});
        LANGUAGES.put("os", new String[]{"Ossetian", "\u0418\u0440\u043e\u043d \u00e6\u0432\u0437\u0430\u0433"});
        LANGUAGES.put("pa", new String[]{"Panjabi", "\u092a\u093e\u0934\u093f"});
        LANGUAGES.put("pl", new String[]{"Polish", "polski"});
        LANGUAGES.put("ps", new String[]{"Pashto", "\u067e\u069a\u062a\u0648"});
        LANGUAGES.put("pt", new String[]{"Portuguese", "Portugu\u00eas"});
        LANGUAGES.put("qu", new String[]{"Quechua", "Runa Simi; Kichwa"});
        LANGUAGES.put("rm", new String[]{"Raeto-Romance", "rumantsch grischun"});
        LANGUAGES.put("rn", new String[]{"Kirundi", "kiRundi"});
        LANGUAGES.put("ro", new String[]{"Romanian", "rom\u00e2n\u0103"});
        LANGUAGES.put("ru", new String[]{"Russian", "\u0440\u0443\u0441\u0441\u043a\u0438\u0439 \u044f\u0437\u044b\u043a"});
        LANGUAGES.put("rw", new String[]{"Kinyarwanda", "Ikinyarwanda"});
        LANGUAGES.put("sa", new String[]{"Sanskrit", "\u0938\u0902\u0938\u094d\u0915\u0943\u0924\u092e\u094d"});
        LANGUAGES.put("sc", new String[]{"Sardinian", "sardu"});
        LANGUAGES.put("sd", new String[]{"Sindhi", "Davvis\u00e1megiella"});
        LANGUAGES.put("sg", new String[]{"Sango", "y\u00e2ng\u00e2 t\u00ee s\u00e4ng\u00f6"});
        LANGUAGES.put("si", new String[]{"Sinhala", "\u0dc3\u0dd2\u0d82\u0dc4\u0dbd"});
        LANGUAGES.put("sk", new String[]{"Slovak", "sloven\u010dina"});
        LANGUAGES.put("sl", new String[]{"Slovenian", "sloven\u0161\u010dina"});
        LANGUAGES.put("sm", new String[]{"Samoan", "gagana fa'a Samoa"});
        LANGUAGES.put("sn", new String[]{"Shona", "chiShona"});
        LANGUAGES.put("so", new String[]{"Somali", "Soomaaliga; af Soomaali"});
        LANGUAGES.put("sq", new String[]{"Albanian", "Shqip"});
        LANGUAGES.put("sr", new String[]{"Serbian", "\u0441\u0440\u043f\u0441\u043a\u0438 \u0458\u0435\u0437\u0438\u043a"});
        LANGUAGES.put("ss", new String[]{"Swati", "SiSwati"});
        LANGUAGES.put("st", new String[]{"Southern Sotho", "Sesotho"});
        LANGUAGES.put("su", new String[]{"Sundanese", "Basa Sunda"});
        LANGUAGES.put("sv", new String[]{"Swedish", "svenska"});
        LANGUAGES.put("sw", new String[]{"Swahili", "Kiswahili"});
        LANGUAGES.put("ta", new String[]{"Tamil", "\u0ba4\u0bae\u0bbf\u0bb4\u0bcd"});
        LANGUAGES.put("te", new String[]{"Telugu", "\u0c24\u0c46\u0c32\u0c41\u0c17\u0c41"});
        LANGUAGES.put("tg", new String[]{"Tajik", "\u0e44\u0e17\u0e22"});
        LANGUAGES.put("ti", new String[]{"Tigrinya", "\u1275\u130d\u122d\u129b"});
        LANGUAGES.put("tk", new String[]{"Turkmen", "T\u00fcrkmen; \u0422\u04af\u0440\u043a\u043c\u0435\u043d"});
        LANGUAGES.put("tl", new String[]{"Tagalog", "Tagalog"});
        LANGUAGES.put("tn", new String[]{"Tswana", "Setswana"});
        LANGUAGES.put("to", new String[]{"Tonga", "faka Tonga"});
        LANGUAGES.put("tr", new String[]{"Turkish", "T\u00fcrk\u00e7e"});
        LANGUAGES.put("ts", new String[]{"Tsonga", "Xitsonga"});
        LANGUAGES.put("tt", new String[]{"Tatar", "Twi"});
        LANGUAGES.put("ty", new String[]{"Tahitian", "Reo M\u0101`ohi"});
        LANGUAGES.put("ug", new String[]{"Uighur", "\u0423\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0430"});
        LANGUAGES.put("ur", new String[]{"Urdu", "\u0627\u0631\u062f\u0648"});
        LANGUAGES.put("uz", new String[]{"Uzbek", "Tshiven\u1e13a"});
        LANGUAGES.put("vi", new String[]{"Vietnamese", "Ti\u1ebfng Vi\u1ec7t"});
        LANGUAGES.put("vo", new String[]{"Volap\u00fck", "Volap\u00fck"});
        LANGUAGES.put("wa", new String[]{"Walloon", "Walon"});
        LANGUAGES.put("wo", new String[]{"Wolof", "Wollof"});
        LANGUAGES.put("xh", new String[]{"Xhosa", "isiXhosa"});
        LANGUAGES.put("yi", new String[]{"Yiddish", "\u05d9\u05d9\u05b4\u05d3\u05d9\u05e9"});
        LANGUAGES.put("yo", new String[]{"Yoruba", "Yor\u00f9b\u00e1"});
        LANGUAGES.put("za", new String[]{"Zhuang", "Sa\u026f cue\u014b\u0185; Saw cuengh"});
        LANGUAGES.put("zh", new String[]{"Chinese", "\u4e2d\u6587 (Zh\u014dngw\u00e9n), \u6c49\u8bed, \u6f22\u8a9e"});
        LANGUAGES.put("zu", new String[]{"Zulu", "isiZulu"});
        COUNTRIES = new HashMap();
        COUNTRIES.put("AD", "Andorra");
        COUNTRIES.put("AE", "United Arab Emirates");
        COUNTRIES.put("AF", "Afghanistan");
        COUNTRIES.put("AG", "Antigua And Barbuda");
        COUNTRIES.put("AI", "Anguilla");
        COUNTRIES.put("AL", "Albania");
        COUNTRIES.put("AM", "Armenia");
        COUNTRIES.put("AN", "Netherlands Antilles");
        COUNTRIES.put("AO", "Angola");
        COUNTRIES.put("AQ", "Antarctica");
        COUNTRIES.put("AR", "Argentina");
        COUNTRIES.put("AS", "American Samoa");
        COUNTRIES.put("AT", "Austria");
        COUNTRIES.put("AU", "Australia");
        COUNTRIES.put("AW", "Aruba");
        COUNTRIES.put("AZ", "Azerbaijan");
        COUNTRIES.put("BA", "Bosnia And Herzegowina");
        COUNTRIES.put("BB", "Barbados");
        COUNTRIES.put("BD", "Bangladesh");
        COUNTRIES.put("BE", "Belgium");
        COUNTRIES.put("BF", "Burkina Faso");
        COUNTRIES.put("BG", "Bulgaria");
        COUNTRIES.put("BH", "Bahrain");
        COUNTRIES.put("BI", "Burundi");
        COUNTRIES.put("BJ", "Benin");
        COUNTRIES.put("BM", "Bermuda");
        COUNTRIES.put("BN", "Brunei Darussalam");
        COUNTRIES.put("BO", "Bolivia");
        COUNTRIES.put("BR", "Brazil");
        COUNTRIES.put("BS", "Bahamas");
        COUNTRIES.put("BT", "Bhutan");
        COUNTRIES.put("BV", "Bouvet Island");
        COUNTRIES.put("BW", "Botswana");
        COUNTRIES.put("BY", "Belarus");
        COUNTRIES.put("BZ", "Belize");
        COUNTRIES.put("CA", "Canada");
        COUNTRIES.put("CC", "Cocos (Keeling) Islands");
        COUNTRIES.put("CF", "Central African Republic");
        COUNTRIES.put("CG", "Congo");
        COUNTRIES.put("CH", "Switzerland");
        COUNTRIES.put("CI", "Cote d'Ivoire");
        COUNTRIES.put("CK", "Cook Islands");
        COUNTRIES.put("CL", "Chile");
        COUNTRIES.put("CM", "Cameroon");
        COUNTRIES.put("CN", "China");
        COUNTRIES.put("CO", "Colombia");
        COUNTRIES.put("CR", "Costa Rica");
        COUNTRIES.put("CU", "Cuba");
        COUNTRIES.put("CV", "Cape Verde");
        COUNTRIES.put("CX", "Christmas Island");
        COUNTRIES.put("CY", "Cyprus");
        COUNTRIES.put("CZ", "Czech Republic");
        COUNTRIES.put("DE", "Germany");
        COUNTRIES.put("DJ", "Djibouti");
        COUNTRIES.put("DK", "Denmark");
        COUNTRIES.put("DM", "Dominica");
        COUNTRIES.put("DO", "Dominican Republic");
        COUNTRIES.put("DZ", "Algeria");
        COUNTRIES.put("EC", "Ecuador");
        COUNTRIES.put("EE", "Estonia");
        COUNTRIES.put("EG", "Egypt");
        COUNTRIES.put("EH", "Western Sahara");
        COUNTRIES.put("ER", "Eritrea");
        COUNTRIES.put("ES", "Spain");
        COUNTRIES.put("ET", "Ethiopia");
        COUNTRIES.put("EU", "Europe (SSGFI only)");
        COUNTRIES.put("FI", "Finland");
        COUNTRIES.put("FJ", "Fiji");
        COUNTRIES.put("FK", "Falkland Islands (Malvinas)");
        COUNTRIES.put("FM", "Micronesia, Federated States Of");
        COUNTRIES.put("FO", "Faroe Islands");
        COUNTRIES.put("FR", "France");
        COUNTRIES.put("FX", "France, Metropolitan");
        COUNTRIES.put("GA", "Gabon");
        COUNTRIES.put("GB", "United Kingdom (UK)");
        COUNTRIES.put("GD", "Grenada");
        COUNTRIES.put("GE", "Georgia");
        COUNTRIES.put("GF", "French Guiana");
        COUNTRIES.put("GH", "Ghana");
        COUNTRIES.put("GI", "Gibraltar");
        COUNTRIES.put("GL", "Greenland");
        COUNTRIES.put("GM", "Gambia");
        COUNTRIES.put("GN", "Guinea");
        COUNTRIES.put("GP", "Guadeloupe");
        COUNTRIES.put("GQ", "Equatorial Guinea");
        COUNTRIES.put("GR", "Greece");
        COUNTRIES.put("GS", "South Georgia And The South Sandwich Islands");
        COUNTRIES.put("GT", "Guatemala");
        COUNTRIES.put("GU", "Guam");
        COUNTRIES.put("GW", "Guinea-Bissau");
        COUNTRIES.put("GY", "Guyana");
        COUNTRIES.put("HK", "Hong Kong");
        COUNTRIES.put("HM", "Heard And Mc Donald Islands");
        COUNTRIES.put("HN", "Honduras");
        COUNTRIES.put("HR", "Croatia (local name: Hrvatska)");
        COUNTRIES.put("HT", "Haiti");
        COUNTRIES.put("HU", "Hungary");
        COUNTRIES.put("ID", "Indonesia");
        COUNTRIES.put("IE", "Ireland");
        COUNTRIES.put("II", "International (SSGFI only)");
        COUNTRIES.put("IL", "Israel");
        COUNTRIES.put("IN", "India");
        COUNTRIES.put("IO", "British Indian Ocean Territory");
        COUNTRIES.put("IQ", "Iraq");
        COUNTRIES.put("IR", "Iran (Islamic Republic Of)");
        COUNTRIES.put("IS", "Iceland");
        COUNTRIES.put("IT", "Italy");
        COUNTRIES.put("JM", "Jamaica");
        COUNTRIES.put("JO", "Jordan");
        COUNTRIES.put("JP", "Japan");
        COUNTRIES.put("KE", "Kenya");
        COUNTRIES.put("KG", "Kyrgyzstan");
        COUNTRIES.put("KH", "Cambodia");
        COUNTRIES.put("KI", "Kiribati");
        COUNTRIES.put("KM", "Comoros");
        COUNTRIES.put("KN", "Saint Kitts And Nevis");
        COUNTRIES.put("KP", "Korea, Democratic People's Republic Of");
        COUNTRIES.put("KR", "Korea, Republic Of");
        COUNTRIES.put("KW", "Kuwait");
        COUNTRIES.put("KY", "Cayman Islands");
        COUNTRIES.put("KZ", "Kazakhstan");
        COUNTRIES.put("LA", "Lao People's Democratic Republic");
        COUNTRIES.put("LB", "Lebanon");
        COUNTRIES.put("LC", "Saint Lucia");
        COUNTRIES.put("LI", "Liechtenstein");
        COUNTRIES.put("LK", "Sri Lanka");
        COUNTRIES.put("LR", "Liberia");
        COUNTRIES.put("LS", "Lesotho");
        COUNTRIES.put("LT", "Lithuania");
        COUNTRIES.put("LU", "Luxembourg");
        COUNTRIES.put("LV", "Latvia");
        COUNTRIES.put("LY", "Libyan Arab Jamahiriya");
        COUNTRIES.put("MA", "Morocco");
        COUNTRIES.put("MC", "Monaco");
        COUNTRIES.put("MD", "Moldova, Republic Of");
        COUNTRIES.put("MG", "Madagascar");
        COUNTRIES.put("MH", "Marshall Islands");
        COUNTRIES.put("MK", "Macedonia, The Former Yugoslav Republic Of");
        COUNTRIES.put("ML", "Mali");
        COUNTRIES.put("MM", "Myanmar");
        COUNTRIES.put("MN", "Mongolia");
        COUNTRIES.put("MO", "Macau");
        COUNTRIES.put("MP", "Northern Mariana Islands");
        COUNTRIES.put("MQ", "Martinique");
        COUNTRIES.put("MR", "Mauritania");
        COUNTRIES.put("MS", "Montserrat");
        COUNTRIES.put("MT", "Malta");
        COUNTRIES.put("MU", "Mauritius");
        COUNTRIES.put("MV", "Maldives");
        COUNTRIES.put("MW", "Malawi");
        COUNTRIES.put("MX", "Mexico");
        COUNTRIES.put("MY", "Malaysia");
        COUNTRIES.put("MZ", "Mozambique");
        COUNTRIES.put("NA", "Namibia");
        COUNTRIES.put("NC", "New Caledonia");
        COUNTRIES.put("NE", "Niger");
        COUNTRIES.put("NF", "Norfolk Island");
        COUNTRIES.put("NG", "Nigeria");
        COUNTRIES.put("NI", "Nicaragua");
        COUNTRIES.put("NL", "Netherlands");
        COUNTRIES.put("NO", "Norway");
        COUNTRIES.put("NP", "Nepal");
        COUNTRIES.put("NR", "Nauru");
        COUNTRIES.put("NU", "Niue");
        COUNTRIES.put("NZ", "New Zealand");
        COUNTRIES.put("OM", "Oman");
        COUNTRIES.put("PE", "Peru");
        COUNTRIES.put("PF", "French Polynesia");
        COUNTRIES.put("PG", "Papua New Guinea");
        COUNTRIES.put("PH", "Philippines");
        COUNTRIES.put("PK", "Pakistan");
        COUNTRIES.put("PL", "Poland");
        COUNTRIES.put("PM", "St. Pierre And Miquelon");
        COUNTRIES.put("PN", "Pitcairn");
        COUNTRIES.put("PR", "Puerto Rico");
        COUNTRIES.put("PT", "Portugal");
        COUNTRIES.put("PW", "Palau");
        COUNTRIES.put("PY", "Paraguay");
        COUNTRIES.put("QA", "Qatar");
        COUNTRIES.put("RE", "Reunion");
        COUNTRIES.put("RO", "Romania");
        COUNTRIES.put("RU", "Russian Federation");
        COUNTRIES.put("RW", "Rwanda");
        COUNTRIES.put("SA", "Saudi Arabia");
        COUNTRIES.put("SB", "Solomon Islands");
        COUNTRIES.put("SC", "Seychelles");
        COUNTRIES.put("SD", "Sudan");
        COUNTRIES.put("SE", "Sweden");
        COUNTRIES.put("SG", "Singapore");
        COUNTRIES.put("SH", "St. Helena");
        COUNTRIES.put("SI", "Slovenia");
        COUNTRIES.put("SJ", "Svalbard And Jan Mayen Islands");
        COUNTRIES.put("SK", "Slovakia (Slovak Republic)");
        COUNTRIES.put("SL", "Sierra Leone");
        COUNTRIES.put("SM", "San Marino");
        COUNTRIES.put("SN", "Senegal");
        COUNTRIES.put("SO", "Somalia");
        COUNTRIES.put("SR", "Suriname");
        COUNTRIES.put("ST", "Sao Tome And Principe");
        COUNTRIES.put("SV", "El Salvador");
        COUNTRIES.put("SY", "Syrian Arab Republic");
        COUNTRIES.put("SZ", "Swaziland");
        COUNTRIES.put("TC", "Turks And Caicos Islands");
        COUNTRIES.put("TD", "Chad");
        COUNTRIES.put("TF", "French Southern Territories");
        COUNTRIES.put("TG", "Togo");
        COUNTRIES.put("TH", "Thailand");
        COUNTRIES.put("TJ", "Tajikistan");
        COUNTRIES.put("TK", "Tokelau");
        COUNTRIES.put("TM", "Turkmenistan");
        COUNTRIES.put("TN", "Tunisia");
        COUNTRIES.put("TO", "Tonga");
        COUNTRIES.put("TP", "East Timor");
        COUNTRIES.put("TR", "Turkey");
        COUNTRIES.put("TT", "Trinidad And Tobago");
        COUNTRIES.put("TV", "Tuvalu");
        COUNTRIES.put("TW", "Taiwan, Province Of China");
        COUNTRIES.put("TZ", "Tanzania, United Republic Of");
        COUNTRIES.put("UA", "Ukraine");
        COUNTRIES.put("UG", "Uganda");
        COUNTRIES.put("UM", "United States Minor Outlying Islands");
        COUNTRIES.put("US", "United States");
        COUNTRIES.put("UY", "Uruguay");
        COUNTRIES.put("UZ", "Uzbekistan");
        COUNTRIES.put("VA", "Vatican City State (Holy See)");
        COUNTRIES.put("VC", "Saint Vincent And The Grenadines");
        COUNTRIES.put("VE", "Venezuela");
        COUNTRIES.put("VG", "Virgin Islands (British)");
        COUNTRIES.put("VI", "Virgin Islands (U.S.)");
        COUNTRIES.put("VN", "Viet Nam");
        COUNTRIES.put("VU", "Vanuatu");
        COUNTRIES.put("WF", "Wallis And Futuna Islands");
        COUNTRIES.put("WS", "Samoa");
        COUNTRIES.put("YE", "Yemen");
        COUNTRIES.put("YT", "Mayotte");
        COUNTRIES.put("YU", "Yugoslavia");
        COUNTRIES.put("ZA", "South Africa");
        COUNTRIES.put("ZM", "Zambia");
        COUNTRIES.put("ZR", "Zaire");
        COUNTRIES.put("ZW", "Zimbabwe");
        EXTENSIONS = new HashMap();
        EXTENSIONS.put("hans", "simplified");
        EXTENSIONS.put("hant", "traditional");
    }

    public static String getNativeLanguage(String code) {
        String[] ret = LANGUAGES.get(code);
        if (ret == null) {
            return null;
        }
        return ret[1];
    }

    public static String[] parseLanguageCode(String lngCode) {
        String[] split = lngCode.split("\\-");
        if (split.length == 1) {
            String languagecode = lngCode.toLowerCase();
            if (languagecode.trim().length() != 2) {
                return null;
            }
            String[] stringArray = new String[3];
            stringArray[0] = lngCode;
            return stringArray;
        }
        if (split.length == 2) {
            boolean h = COUNTRIES.containsKey(split[1].toUpperCase());
            if (split[0].trim().length() != 2) {
                return null;
            }
            return new String[]{split[0].toLowerCase(), h ? split[1].toUpperCase() : null, h ? null : split[1]};
        }
        split = lngCode.split("\\-");
        if (split[0].trim().length() != 2) {
            return null;
        }
        if (split[1].trim().length() != 2) {
            return null;
        }
        return new String[]{split[0].toLowerCase(), split[1].toUpperCase(), split[2]};
    }

    public static String toLonger(String string) {
        String[] p = JDGeoCode.parseLanguageCode(string);
        if (p == null) {
            return null;
        }
        String language = LANGUAGES.get(p[0])[0];
        String country = COUNTRIES.get(p[1]);
        String extension = EXTENSIONS.get(p[2]);
        if (extension == null) {
            extension = p[2];
        }
        String ret = language;
        if (country != null) {
            ret = String.valueOf(ret) + " [" + country;
            if (extension != null) {
                ret = String.valueOf(ret) + " | " + extension;
            }
            ret = String.valueOf(ret) + "]";
        } else if (extension != null) {
            ret = String.valueOf(ret) + " [" + extension + "]";
        }
        return ret;
    }

    public static String toLongerNative(String string) {
        String[] p = JDGeoCode.parseLanguageCode(string);
        String language = LANGUAGES.get(p[0])[1];
        String country = COUNTRIES.get(p[1]);
        String extension = EXTENSIONS.get(p[2]);
        if (extension == null) {
            extension = p[2];
        }
        String ret = language;
        if (country != null) {
            ret = String.valueOf(ret) + " [" + country;
            if (extension != null) {
                ret = String.valueOf(ret) + " | " + extension;
            }
            ret = String.valueOf(ret) + "]";
        } else if (extension != null) {
            ret = String.valueOf(ret) + " [" + extension + "]";
        }
        return ret;
    }

    public static String longToShort(String lng) {
        String[] row = new Regex(lng, "(.*?)\\[(.*)\\|(.*?)\\]").getRow(0);
        if (row != null) {
            return String.valueOf(JDGeoCode.getLanguageCode(row[0].trim())) + "-" + JDGeoCode.getCountryCode(row[1].trim()) + "-" + JDGeoCode.getExtensionCode(row[2].trim());
        }
        row = new Regex(lng, "(.*?)\\[(.*)\\]").getRow(0);
        if (row != null) {
            String countryCode = JDGeoCode.getCountryCode(row[1].trim());
            if (countryCode != null) {
                return String.valueOf(JDGeoCode.getLanguageCode(row[0].trim())) + "-" + countryCode;
            }
            return String.valueOf(JDGeoCode.getLanguageCode(row[0].trim())) + "-" + JDGeoCode.getExtensionCode(row[1].trim());
        }
        return JDGeoCode.getLanguageCode(lng.trim());
    }

    public static String getLanguageCode(String name) {
        for (Map.Entry<String, String[]> next : LANGUAGES.entrySet()) {
            if (!next.getValue()[0].equalsIgnoreCase(name) && !next.getValue()[1].equalsIgnoreCase(name)) continue;
            return next.getKey();
        }
        return null;
    }

    public static String getExtensionCode(String name) {
        for (Map.Entry<String, String> next : EXTENSIONS.entrySet()) {
            if (!next.getValue().equalsIgnoreCase(name)) continue;
            return next.getKey();
        }
        return name;
    }

    public static String getCountryCode(String name) {
        for (Map.Entry<String, String> next : COUNTRIES.entrySet()) {
            if (!next.getValue().equalsIgnoreCase(name)) continue;
            return next.getKey();
        }
        return null;
    }
}

