/*
 * Decompiled with CFR 0.152.
 */
package jd.utils;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jd.CPluginWrapper;
import jd.HostPluginWrapper;
import jd.JDClassLoader;
import jd.OptionalPluginWrapper;
import jd.config.Configuration;
import jd.config.DatabaseConnector;
import jd.controlling.DownloadController;
import jd.controlling.JDController;
import jd.controlling.JDLogger;
import jd.gui.UserIO;
import jd.nutils.Executer;
import jd.nutils.Formatter;
import jd.nutils.OSDetector;
import jd.nutils.io.JDIO;
import jd.plugins.CryptedLink;
import jd.plugins.DownloadLink;
import jd.plugins.PluginForHost;
import jd.plugins.PluginsC;
import jd.update.WebUpdater;
import jd.utils.GetExplorer;
import jd.utils.locale.JDL;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDUtilities {
    public static Configuration CONFIGURATION = null;
    private static DatabaseConnector DB_CONNECT = null;
    private static HashMap<String, PluginsC> CONTAINER_PLUGINS = new HashMap();
    private static JDController CONTROLLER = null;
    public static final String JD_TITLE = "jDownloader";
    public static final String JD_VERSION = "0.";
    private static JDClassLoader JD_CLASSLOADER = null;
    public static final int RUNTYPE_LOCAL = 1;
    public static final int RUNTYPE_LOCAL_JARED = 2;
    private static File JD_HOME = null;
    public static final Object USERIO_LOCK = new Object();
    private static String REVISION;
    private static String[] JD_ARGUMENTS;

    static {
        JD_ARGUMENTS = new String[1];
    }

    public static <K extends Comparable<K>, V> TreeMap<K, V> revSortByKey(Map<K, V> map) {
        TreeMap<K, V> a = new TreeMap<K, V>(new Comparator<K>(){

            @Override
            public int compare(K o1, K o2) {
                return o2.compareTo(o1);
            }
        });
        a.putAll(map);
        return a;
    }

    public static <K extends Comparable<K>, V> TreeMap<K, V> sortByKey(Map<K, V> map) {
        TreeMap<K, V> a = new TreeMap<K, V>(new Comparator<K>(){

            @Override
            public int compare(K o1, K o2) {
                return o1.compareTo(o2);
            }
        });
        a.putAll(map);
        return a;
    }

    public static void addToGridBag(Container cont, Component comp, int x, int y, int width, int height, int weightX, int weightY, Insets insets, int fill, int anchor) {
        if (cont == null) {
            JDLogger.getLogger().severe("Container ==null");
            return;
        }
        if (comp == null) {
            JDLogger.getLogger().severe("Componente ==null");
            return;
        }
        JDUtilities.addToGridBag(cont, comp, x, y, width, height, weightX, weightY, insets, 0, 0, fill, anchor);
    }

    public static void addToGridBag(Container cont, Component comp, int x, int y, int width, int height, int weightX, int weightY, Insets insets, int iPadX, int iPadY, int fill, int anchor) {
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = x;
        cons.gridy = y;
        cons.gridwidth = width;
        cons.gridheight = height;
        cons.weightx = weightX;
        cons.weighty = weightY;
        cons.fill = fill;
        cons.anchor = anchor;
        if (insets != null) {
            cons.insets = insets;
        }
        cons.ipadx = iPadX;
        cons.ipady = iPadY;
        cont.add(comp, cons);
    }

    public static String convertExceptionReadable(Exception e) {
        String s = e.getClass().getName().replaceAll("Exception", "");
        s = s.substring(s.lastIndexOf(".") + 1);
        StringBuilder ret = new StringBuilder();
        String letter = null;
        int i = 0;
        while (i < s.length()) {
            letter = s.substring(i, i + 1);
            if (letter.equals(letter.toUpperCase())) {
                ret.append(' ');
                ret.append(letter);
            } else {
                ret.append(letter);
            }
            ++i;
        }
        String message = e.getLocalizedMessage();
        String rets = ret.toString();
        return message != null ? String.valueOf(rets.trim()) + ": " + message : rets.trim();
    }

    public static String createContainerString(ArrayList<DownloadLink> downloadLinks, String encryption) {
        ArrayList pfc = CPluginWrapper.getCWrapper();
        int i = 0;
        while (i < pfc.size()) {
            String pn = ((CPluginWrapper)pfc.get(i)).getHost();
            if (pn.equalsIgnoreCase(encryption)) {
                return ((CPluginWrapper)pfc.get(i)).getPlugin().createContainerString(downloadLinks);
            }
            ++i;
        }
        return null;
    }

    public static String[] encrypt(String string, String encryption) {
        ArrayList pfc = CPluginWrapper.getCWrapper();
        int i = 0;
        while (i < pfc.size()) {
            if (((CPluginWrapper)pfc.get(i)).getHost().equalsIgnoreCase(encryption)) {
                return ((CPluginWrapper)pfc.get(i)).getPlugin().encrypt(string);
            }
            ++i;
        }
        return null;
    }

    public static String getUserInput(String message, DownloadLink link) throws InterruptedException {
        return JDUtilities.getUserInput(message, null, link);
    }

    public static String getUserInput(String message, String defaultmessage, DownloadLink link) throws InterruptedException {
        try {
            link.getLinkStatus().addStatus(0x800000);
            link.requestGuiUpdate();
            String code = JDUtilities.getUserInput(message, defaultmessage);
            link.requestGuiUpdate();
            String string = code;
            return string;
        }
        finally {
            link.getLinkStatus().removeStatus(0x800000);
        }
    }

    public static String getUserInput(String message, CryptedLink link) throws InterruptedException {
        return JDUtilities.getUserInput(message, null, link);
    }

    public static String getUserInput(String message, String defaultmessage, CryptedLink link) throws InterruptedException {
        link.getProgressController().setStatusText(JDL.L((String)"gui.linkgrabber.waitinguserio", (String)"Waiting for user input"));
        String password = JDUtilities.getUserInput(message, defaultmessage);
        link.getProgressController().setStatusText(null);
        return password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUserInput(String message, String defaultmessage) throws InterruptedException {
        Object object = USERIO_LOCK;
        synchronized (object) {
            if (message == null) {
                message = JDL.L((String)"gui.linkgrabber.password", (String)"Password?");
            }
            if (defaultmessage == null) {
                defaultmessage = "";
            }
            String password = UserIO.getInstance().requestInputDialog(0, message, defaultmessage);
            return password;
        }
    }

    public static Configuration getConfiguration() {
        if (CONFIGURATION == null) {
            CONFIGURATION = new Configuration();
        }
        return CONFIGURATION;
    }

    public static JDController getController() {
        return CONTROLLER;
    }

    public static long getCRC(File file) {
        CheckedInputStream cis = null;
        try {
            cis = new CheckedInputStream(new FileInputStream(file), new CRC32());
        }
        catch (FileNotFoundException e) {
            JDLogger.exception(e);
            return 0L;
        }
        try {
            byte[] buf = new byte[128];
            while (cis.read(buf) >= 0) {
            }
            long checksum = cis.getChecksum().getValue();
            return checksum;
        }
        catch (IOException e) {
            JDLogger.exception(e);
            return 0L;
        }
    }

    public static File getCurrentWorkingDirectory(String id) {
        if (id == null) {
            id = "";
        }
        String dlDir = JDUtilities.getConfiguration().getStringProperty("DOWNLOAD_DIRECTORY", null);
        String lastDir = JDUtilities.getConfiguration().getStringProperty("CURRENT_BROWSE_PATH" + id, null);
        File dlDirectory = dlDir == null ? new File("") : new File(dlDir);
        if (lastDir == null) {
            return dlDirectory;
        }
        return new File(lastDir);
    }

    public static String getJACMethodsDirectory() {
        return "jd/captcha/methods/";
    }

    public static Double getJavaVersion() {
        String version = System.getProperty("java.version");
        int majorVersion = Formatter.filterInt(version.substring(0, version.indexOf(".")));
        int subversion = Formatter.filterInt(version.substring(version.indexOf(".") + 1));
        return Double.parseDouble(String.valueOf(majorVersion) + "." + subversion);
    }

    public static JDClassLoader getJDClassLoader() {
        if (JD_CLASSLOADER == null) {
            File homeDir = JDUtilities.getJDHomeDirectoryFromEnvironment();
            JDLogger.getLogger().finest("Create Classloader: for: " + homeDir.getAbsolutePath());
            JD_CLASSLOADER = new JDClassLoader(homeDir.getAbsolutePath(), Thread.currentThread().getContextClassLoader());
        }
        return JD_CLASSLOADER;
    }

    public static File getJDHomeDirectoryFromEnvironment() {
        File jdHomeDir;
        if (JD_HOME != null) {
            return JD_HOME;
        }
        String envDir = null;
        File currentDir = null;
        URL ressource = Thread.currentThread().getContextClassLoader().getResource("jd/Main.class");
        if (ressource == null) {
            ressource = Thread.currentThread().getContextClassLoader().getResource("jd/update/Main.class");
        }
        String dir = "" + ressource;
        dir = String.valueOf(dir.split("\\.jar\\!")[0]) + ".jar";
        dir = dir.substring(Math.max(dir.indexOf("file:"), 0));
        try {
            currentDir = new File(new URI(dir));
            if (currentDir.isFile()) {
                currentDir = currentDir.getParentFile();
            }
        }
        catch (URISyntaxException e) {
            JDLogger.exception(e);
        }
        switch (JDUtilities.getRunType()) {
            case 2: {
                System.out.println("JAR");
                envDir = currentDir.getAbsolutePath();
                break;
            }
            default: {
                System.out.println("USER");
                envDir = String.valueOf(System.getProperty("user.home")) + System.getProperty("file.separator") + ".jd_home/";
            }
        }
        if (envDir == null) {
            envDir = "." + System.getProperty("file.separator") + ".jd_home/";
            JDLogger.getLogger().info("JD_HOME from current directory:" + envDir);
        }
        if (!(jdHomeDir = new File(envDir)).exists()) {
            jdHomeDir.mkdirs();
        }
        JD_HOME = jdHomeDir;
        return jdHomeDir;
    }

    public static String getJDTitle() {
        StringBuilder ret = new StringBuilder(JD_TITLE);
        if (WebUpdater.getConfig("WEBUPDATE").getStringProperty("BRANCHINUSE", null) != null) {
            ret.append(' ');
            ret.append('(');
            ret.append(WebUpdater.getConfig("WEBUPDATE").getStringProperty("BRANCHINUSE", null));
            ret.append(')');
        }
        ret.append(' ');
        ret.append(JD_VERSION);
        ret.append(JDUtilities.getRevision());
        if (JDUtilities.getController() != null && JDUtilities.getController().getWaitingUpdates() != null && JDUtilities.getController().getWaitingUpdates().size() > 0) {
            ret.append(' ');
            ret.append(JDL.L((String)"gui.mainframe.title.updatemessage", (String)"-->UPDATES VERF\u00dcGBAR:"));
            ret.append(' ');
            ret.append(JDUtilities.getController().getWaitingUpdates().size());
        }
        return ret.toString();
    }

    public static String getPercent(long downloadCurrent, long downloadMax) {
        DecimalFormat c = new DecimalFormat("0.00");
        return String.valueOf(c.format(100.0 * (double)downloadCurrent / (double)downloadMax)) + "%";
    }

    public static PluginsC getPluginForContainer(String container, String containerPath) {
        if (containerPath != null && CONTAINER_PLUGINS.containsKey(containerPath)) {
            return CONTAINER_PLUGINS.get(containerPath);
        }
        PluginsC ret = null;
        for (CPluginWrapper act : CPluginWrapper.getCWrapper()) {
            if (!act.getHost().equalsIgnoreCase(container)) continue;
            ret = (PluginsC)act.getNewPluginInstance();
            if (containerPath != null) {
                CONTAINER_PLUGINS.put(containerPath, ret);
            }
            return ret;
        }
        return null;
    }

    public static PluginForHost getPluginForHost(String host) {
        for (HostPluginWrapper pHost : JDUtilities.getPluginsForHost()) {
            if (!pHost.getHost().equals(host.toLowerCase())) continue;
            return pHost.getPlugin();
        }
        return null;
    }

    public static PluginForHost getNewPluginForHostInstance(String host) {
        for (HostPluginWrapper pHost : JDUtilities.getPluginsForHost()) {
            if (!pHost.getHost().equals(host.toLowerCase())) continue;
            return (PluginForHost)pHost.getNewPluginInstance();
        }
        return null;
    }

    public static OptionalPluginWrapper getOptionalPlugin(String id) {
        for (OptionalPluginWrapper wrapper : OptionalPluginWrapper.getOptionalWrapper()) {
            if (wrapper.getID() == null || !wrapper.getID().equalsIgnoreCase(id)) continue;
            return wrapper;
        }
        return null;
    }

    public static ArrayList<HostPluginWrapper> getPluginsForHost() {
        return new ArrayList<HostPluginWrapper>(HostPluginWrapper.getHostWrapper());
    }

    public static ArrayList<HostPluginWrapper> getPremiumPluginsForHost() {
        ArrayList<HostPluginWrapper> plugins = JDUtilities.getPluginsForHost();
        int i = plugins.size() - 1;
        while (i >= 0) {
            if (!plugins.get(i).isPremiumEnabled()) {
                plugins.remove(i);
            }
            --i;
        }
        return plugins;
    }

    public static String getRevision() {
        if (REVISION != null) {
            return REVISION;
        }
        int rev = -1;
        try {
            rev = Formatter.filterInt(JDIO.getLocalFile(JDUtilities.getResourceFile("config/version.cfg")));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        int rev2 = Integer.parseInt(Formatter.getRevision("$Revision: 7504 $"));
        double r = (double)Math.max(rev2, rev) / 1000.0;
        REVISION = new DecimalFormat("0.000").format(r).replace(",", ".");
        return REVISION;
    }

    public static int getRunType() {
        String caller = "" + Thread.currentThread().getContextClassLoader().getResource("jd");
        if (caller.matches("jar\\:.*\\.jar\\!.*")) {
            return 2;
        }
        return 1;
    }

    public static void setJDargs(String[] args) {
        JD_ARGUMENTS = args;
    }

    public static String[] getJDargs() {
        return JD_ARGUMENTS;
    }

    public static void restartJDandWait() {
        JDUtilities.restartJD(false);
        while (true) {
            try {
                while (true) {
                    Thread.sleep(5000L);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public static void restartJD(final boolean tinybypass) {
        new Thread(new Runnable(){

            public void run() {
                if (JDUtilities.getController() != null) {
                    JDUtilities.getController().prepareShutdown();
                }
                List<String> lst = ManagementFactory.getRuntimeMXBean().getInputArguments();
                ArrayList<String> jargs = new ArrayList<String>();
                boolean xmxset = false;
                boolean xmsset = false;
                boolean useconc = false;
                boolean minheap = false;
                boolean maxheap = false;
                System.out.println("RESTART NOW");
                for (String h : lst) {
                    if (h.contains("Xmx")) {
                        xmxset = true;
                        if (Runtime.getRuntime().maxMemory() < 533000000L) {
                            jargs.add("-Xmx512m");
                            continue;
                        }
                    } else if (h.contains("xms")) {
                        xmsset = true;
                    } else if (h.contains("XX:+useconc")) {
                        useconc = true;
                    } else if (h.contains("minheapfree")) {
                        minheap = true;
                    } else if (h.contains("maxheapfree")) {
                        maxheap = true;
                    }
                    jargs.add(h);
                }
                if (!xmxset) {
                    jargs.add("-Xmx512m");
                }
                if (OSDetector.isLinux()) {
                    if (!xmsset) {
                        jargs.add("-Xms64m");
                    }
                    if (!useconc) {
                        jargs.add("-XX:+UseConcMarkSweepGC");
                    }
                    if (!minheap) {
                        jargs.add("-XX:MinHeapFreeRatio=0");
                    }
                    if (!maxheap) {
                        jargs.add("-XX:MaxHeapFreeRatio=0");
                    }
                }
                jargs.add("-jar");
                jargs.add("JDownloader.jar");
                String[] javaArgs = jargs.toArray(new String[jargs.size()]);
                String[] finalArgs = new String[JD_ARGUMENTS.length + javaArgs.length];
                System.arraycopy(javaArgs, 0, finalArgs, 0, javaArgs.length);
                System.arraycopy(JD_ARGUMENTS, 0, finalArgs, javaArgs.length, JD_ARGUMENTS.length);
                ArrayList<File> restartfiles = JDIO.listFiles(JDUtilities.getResourceFile("update"));
                if (restartfiles != null && restartfiles.size() > 0 || tinybypass) {
                    if (OSDetector.isMac()) {
                        JDLogger.getLogger().info(JDUtilities.runCommand("java", new String[]{"-jar", "tools/tinyupdate.jar", "-restart"}, JDUtilities.getResourceFile(".").getAbsolutePath(), 0));
                    } else {
                        JDLogger.getLogger().info(JDUtilities.runCommand("java", new String[]{"-jar", "tools/tinyupdate.jar", "-restart"}, JDUtilities.getResourceFile(".").getAbsolutePath(), 0));
                    }
                } else if (OSDetector.isMac()) {
                    JDLogger.getLogger().info(JDUtilities.runCommand("open", new String[]{"-n", "jDownloader.app"}, JDUtilities.getResourceFile(".").getParentFile().getParentFile().getParentFile().getParentFile().getAbsolutePath(), 0));
                } else {
                    JDLogger.getLogger().info(JDUtilities.runCommand("java", finalArgs, JDUtilities.getResourceFile(".").getAbsolutePath(), 0));
                }
                System.out.println("EXIT NOW");
                System.exit(0);
            }
        }).start();
    }

    public static URL getResourceURL(String resource) {
        JDClassLoader cl = JDUtilities.getJDClassLoader();
        if (cl == null) {
            System.err.println("Classloader == null");
            return null;
        }
        return cl.getResource(resource);
    }

    public static File getResourceFile(String resource) {
        URL clURL = JDUtilities.getResourceURL(resource);
        if (clURL != null) {
            try {
                return new File(clURL.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String runCommand(String command, String[] parameter, String runIn, int waitForReturn) {
        Executer exec = new Executer(command);
        exec.addParameters(parameter);
        exec.setRunin(runIn);
        exec.setWaitTimeout(waitForReturn);
        exec.start();
        exec.waitTimeout();
        return String.valueOf(exec.getOutputStream()) + " \r\n " + exec.getErrorStream();
    }

    public static void saveConfig() {
        JDUtilities.getConfiguration().save();
    }

    public static String objectToXml(Object obj) throws IOException {
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(ba);
        XMLEncoder xmlEncoder = new XMLEncoder(out);
        xmlEncoder.writeObject(obj);
        xmlEncoder.close();
        out.close();
        return new String(ba.toByteArray());
    }

    public static Object xmlStringToObjekt(String in) throws IOException {
        Object objectLoaded = null;
        ByteArrayInputStream ba = new ByteArrayInputStream(in.getBytes());
        XMLDecoder xmlDecoder = new XMLDecoder(ba);
        objectLoaded = xmlDecoder.readObject();
        xmlDecoder.close();
        ba.close();
        return objectLoaded;
    }

    public static void setConfiguration(Configuration configuration) {
        CONFIGURATION = configuration;
    }

    public static void setController(JDController con) {
        CONTROLLER = con;
    }

    public static DownloadController getDownloadController() {
        return DownloadController.getInstance();
    }

    public static void setCurrentWorkingDirectory(File f, String id) {
        if (id == null) {
            id = "";
        }
        JDUtilities.getConfiguration().setProperty("CURRENT_BROWSE_PATH" + id, f.getAbsolutePath());
        JDUtilities.getConfiguration().save();
    }

    public static boolean sleep(int i) {
        try {
            Thread.sleep(i);
            return true;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public static String removeEndingPoints(String name) {
        if (name == null) {
            return null;
        }
        String ret = name.trim();
        while (ret.endsWith(".")) {
            ret = ret.substring(0, ret.length() - 1);
        }
        return ret;
    }

    public static synchronized DatabaseConnector getDatabaseConnector() {
        if (DB_CONNECT == null) {
            try {
                DB_CONNECT = new DatabaseConnector();
            }
            catch (Exception e) {
                JDLogger.exception(e);
                String configpath = String.valueOf(JDUtilities.getJDHomeDirectoryFromEnvironment().getAbsolutePath()) + "/config/";
                Logger logger = JDLogger.getLogger();
                if (e.getMessage().equals("Database broken!")) {
                    logger.severe("Database broken! Creating fresh Database");
                    if (!new File(String.valueOf(configpath) + "database.script").delete() || !new File(String.valueOf(configpath) + "database.properties").delete()) {
                        logger.severe("Could not delete broken Database");
                        UserIO.getInstance().requestMessageDialog("Could not delete broken database. Please remove the JD_HOME/config directory and restart JD");
                    }
                }
                try {
                    DB_CONNECT = new DatabaseConnector();
                }
                catch (Exception e1) {
                    JDLogger.exception(e1);
                    UserIO.getInstance().requestMessageDialog("Could not create database. Please remove the JD_HOME/config directory and restart JD");
                    System.exit(1);
                }
            }
        }
        return DB_CONNECT;
    }

    public static boolean openExplorer(File path) {
        try {
            return new GetExplorer().openExplorer(path);
        }
        catch (Exception e) {
            JDLogger.exception(e);
            return false;
        }
    }

    public static String[] passwordStringToArray(String password) {
        if (password == null || password.matches("[\\s]*")) {
            return new String[0];
        }
        if (password.matches("[\\s]*\\{[\\s]*\".*\"[\\s]*\\}[\\s]*$")) {
            password = password.replaceFirst("[\\s]*\\{[\\s]*\"", "").replaceFirst("\"[\\s]*\\}[\\s]*$", "");
            return password.split("\"[\\s]*\\,[\\s]*\"");
        }
        return new String[]{password};
    }

    public static ArrayList<String> mergePasswords(ArrayList<String> passwords, String newpassword) {
        String[] newpws = JDUtilities.passwordStringToArray(newpassword);
        if (newpws.length == 0) {
            return passwords;
        }
        if (passwords == null) {
            passwords = new ArrayList();
        }
        String[] stringArray = newpws;
        int n = newpws.length;
        int n2 = 0;
        while (n2 < n) {
            String newpw = stringArray[n2];
            if (!passwords.contains(newpw)) {
                passwords.add(newpw);
            }
            ++n2;
        }
        return passwords;
    }

    public static String passwordArrayToString(String[] passwords) {
        LinkedList<String> pws = new LinkedList<String>();
        int i = 0;
        while (i < passwords.length) {
            if (!passwords[i].matches("[\\s]*") && !pws.contains(passwords[i])) {
                pws.add(passwords[i]);
            }
            ++i;
        }
        passwords = pws.toArray(new String[pws.size()]);
        if (passwords.length == 0) {
            return "";
        }
        if (passwords.length == 1) {
            return passwords[0];
        }
        int l = passwords.length - 1;
        StringBuilder ret = new StringBuilder();
        ret.append(new char[]{'{', '\"'});
        int i2 = 0;
        while (i2 < passwords.length) {
            if (!passwords[i2].matches("[\\s]*")) {
                ret.append(passwords[i2]);
                if (i2 == l) {
                    ret.append(new char[]{'\"', '}'});
                } else {
                    ret.append(new char[]{'\"', ',', '\"'});
                }
            }
            ++i2;
        }
        return ret.toString();
    }

    public static Document parseXmlString(String xmlString, boolean validating) {
        if (xmlString == null) {
            return null;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(validating);
            InputSource inSource = new InputSource(new StringReader(xmlString));
            Document doc = factory.newDocumentBuilder().parse(inSource);
            return doc;
        }
        catch (Exception e) {
            JDLogger.exception(e);
            return null;
        }
    }

    public static String createXmlString(Document doc) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult result = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource(doc);
            transformer.transform(source, result);
            return result.getWriter().toString();
        }
        catch (TransformerException e) {
            JDLogger.exception(e);
            return null;
        }
    }

    public static String getAttribute(Node childNode, String key) {
        NamedNodeMap att = childNode.getAttributes();
        if (att == null || att.getNamedItem(key) == null) {
            return null;
        }
        return att.getNamedItem(key).getNodeValue();
    }
}

