/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.optional.webinterface;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import jd.config.SubConfiguration;
import jd.controlling.JDLogger;
import jd.nutils.encoding.Encoding;
import jd.nutils.io.JDIO;
import jd.parser.Regex;
import jd.plugins.optional.webinterface.JDSimpleWebserverRequestHandler;
import jd.plugins.optional.webinterface.JDSimpleWebserverResponseCreator;
import jd.utils.JDHexUtils;
import jd.utils.JDUtilities;

public class JDSimpleWebserver
extends Thread {
    private static String AuthUser = "";
    private static boolean NeedAuth = false;
    private Logger logger = JDLogger.getLogger();
    private boolean Server_Running = true;
    private ServerSocket Server_Socket;

    public SSLServerSocketFactory setupSSL() throws Exception {
        char[] password = "jdwebinterface".toCharArray();
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        FileInputStream fis = new FileInputStream(JDUtilities.getResourceFile((String)"plugins/webinterface/jdwebinterface").getAbsolutePath());
        ks.load(fis, password);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(ks, password);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ks);
        SSLContext c = SSLContext.getInstance("SSL");
        c.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        SSLServerSocketFactory sf = c.getServerSocketFactory();
        return sf;
    }

    public JDSimpleWebserver() {
        SubConfiguration subConfig = SubConfiguration.getConfig((String)"WEBINTERFACE");
        Boolean https = subConfig.getBooleanProperty("PARAM_HTTPS", false);
        AuthUser = "Basic " + Encoding.Base64Encode((String)(String.valueOf(subConfig.getStringProperty("PARAM_USER", "JD")) + ":" + subConfig.getStringProperty("PARAM_PASS", "JD")));
        NeedAuth = subConfig.getBooleanProperty("PARAM_LOGIN", true);
        int port = subConfig.getIntegerProperty("PARAM_PORT", 8765);
        try {
            if (!https.booleanValue()) {
                this.Server_Socket = new ServerSocket(port);
            } else {
                try {
                    SSLServerSocketFactory ssocketFactory = this.setupSSL();
                    this.Server_Socket = ssocketFactory.createServerSocket(port);
                }
                catch (Exception e) {
                    this.logger.severe("WebInterface: Server failed to start (SSL Setup Failed)!");
                    return;
                }
            }
            this.logger.info("Webinterface: Server started");
            this.start();
        }
        catch (IOException e) {
            this.logger.severe("WebInterface: Server failed to start!");
        }
    }

    public void run() {
        this.setName("Webinterface");
        while (this.Server_Running) {
            try {
                Socket Client_Socket = this.Server_Socket.accept();
                Thread client_thread = new Thread(new JDRequestHandler(Client_Socket));
                client_thread.start();
            }
            catch (IOException e) {
                JDLogger.exception((Throwable)e);
                this.logger.severe("WebInterface: Client-Connection failed");
            }
        }
    }

    private class JDRequestHandler
    implements Runnable {
        private Socket Current_Socket;
        private Logger logger = JDLogger.getLogger();

        public JDRequestHandler(Socket Client_Socket) {
            this.Current_Socket = Client_Socket;
        }

        public String readline(BufferedInputStream in) {
            StringBuilder data;
            block6: {
                data = new StringBuilder("");
                in.mark(1);
                if (in.read() != -1) break block6;
                return null;
            }
            try {
                int c;
                in.reset();
                while ((c = in.read()) >= 0) {
                    if (c == 0 || c == 10 || c == 13) break;
                    data.append((char)c);
                }
                if (c == 13) {
                    in.mark(1);
                    if (in.read() != 10) {
                        in.reset();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return data.toString();
        }

        public void run() {
            try {
                InputStream requestInputStream = this.Current_Socket.getInputStream();
                BufferedInputStream reader = new BufferedInputStream(requestInputStream);
                String line = null;
                HashMap<String, String> headers = new HashMap<String, String>();
                while ((line = this.readline(reader)) != null && line.trim().length() > 0) {
                    String key = null;
                    String value = null;
                    if (line.indexOf(": ") > 0) {
                        key = line.substring(0, line.indexOf(": ")).toLowerCase();
                        value = line.substring(line.indexOf(": ") + 2);
                    } else {
                        key = null;
                        value = line;
                    }
                    headers.put(key, value);
                }
                if (headers.containsKey(null)) {
                    String Method = ((String)headers.get(null)).split(" ")[0];
                    if (Method.compareToIgnoreCase("get") == 0 || Method.compareToIgnoreCase("post") == 0) {
                        if (headers.containsKey("content-type")) {
                            int post_len_read;
                            int post_len_toread;
                            if (((String)headers.get("content-type")).compareToIgnoreCase("application/x-www-form-urlencoded") == 0) {
                                if (headers.containsKey("content-length")) {
                                    int post_len;
                                    post_len_toread = post_len = new Integer(headers.get("content-length")).intValue();
                                    post_len_read = 0;
                                    byte[] cbuf = new byte[post_len];
                                    int indexstart = 0;
                                    while (post_len_toread > 0) {
                                        post_len_read = reader.read(cbuf, indexstart, post_len_toread);
                                        if (post_len_read == -1) break;
                                        indexstart += post_len_read;
                                        post_len_toread -= post_len_read;
                                    }
                                    String RequestParams = new String(cbuf).trim();
                                    if (indexstart == post_len) {
                                        String request = headers.get(null);
                                        String[] requ = request.split(" ");
                                        if (Method.compareToIgnoreCase("post") == 0) {
                                            headers.put(null, String.valueOf(requ[0]) + " " + requ[1] + "?" + RequestParams + " " + requ[2]);
                                        } else {
                                            this.logger.severe("POST Daten bei nem GET aufruf???");
                                        }
                                    } else {
                                        this.logger.severe("POST Fehler postlen soll = " + post_len + " postlen gelesen = " + post_len_read);
                                    }
                                }
                            } else if (headers.get("content-type").contains("multipart/form-data") && headers.containsKey("content-length")) {
                                int post_len;
                                post_len_toread = post_len = new Integer(headers.get("content-length")).intValue();
                                post_len_read = 0;
                                byte[] cbuf = new byte[post_len];
                                int indexstart = 0;
                                String limiter = new Regex(headers.get("content-type"), Pattern.compile("boundary=(.*)", 2)).getMatch(0);
                                if (limiter != null) {
                                    limiter = "--" + limiter;
                                    limiter = JDHexUtils.getHexString((String)limiter);
                                    while (post_len_toread > 0) {
                                        post_len_read = reader.read(cbuf, indexstart, post_len_toread);
                                        if (post_len_read == -1) break;
                                        indexstart += post_len_read;
                                        post_len_toread -= post_len_read;
                                    }
                                    if (indexstart == post_len) {
                                        String[][] MultiPartData;
                                        String RequestParams = "";
                                        String[][] stringArray = MultiPartData = new Regex(JDHexUtils.getHexString((byte[])cbuf), Pattern.compile(String.valueOf(limiter) + JDHexUtils.getHexString((String)"\r") + "{0,1}" + JDHexUtils.getHexString((String)"\n") + "{0,1}" + "([[a-fA-F0-9]{2}]*?)" + "(?=" + JDHexUtils.getHexString((String)"\r") + "{0,1}" + JDHexUtils.getHexString((String)"\n") + "{0,1}" + limiter + ")", 34)).getMatches();
                                        int n = MultiPartData.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            String[] element = stringArray[n2];
                                            if (element[0].contains(JDHexUtils.getHexString((String)"Content-Disposition: form-data; name=\"container\""))) {
                                                String containertyp = new Regex(element[0], Pattern.compile(String.valueOf(JDHexUtils.getHexString((String)"filename=\"")) + "[[a-fA-F0-9]{2}]*?" + JDHexUtils.getHexString((String)".") + "([[a-fA-F0-9]{2}]*?)" + JDHexUtils.getHexString((String)"\""), 2)).getMatch(0);
                                                if (containertyp != null) {
                                                    containertyp = new String(JDHexUtils.getByteArray((String)containertyp));
                                                }
                                                if (containertyp != null && (containertyp.contains("dlc") || containertyp.contains("ccf") || containertyp.contains("rsdf") || containertyp.contains("jdc"))) {
                                                    File containerfile = JDUtilities.getResourceFile((String)("container/" + System.currentTimeMillis() + "." + containertyp));
                                                    if (JDIO.saveToFile((File)containerfile, (byte[])JDHexUtils.getByteArray((String)element[0].substring(element[0].indexOf(JDHexUtils.getHexString((String)"\r\n\r\n")) + 8)))) {
                                                        RequestParams = "do=Upload&file=" + Encoding.urlEncode((String)containerfile.getName());
                                                        break;
                                                    }
                                                } else if (containertyp != null) {
                                                    this.logger.severe("unknown container typ: " + containertyp);
                                                }
                                            }
                                            ++n2;
                                        }
                                        String request = headers.get(null);
                                        String[] requ = request.split(" ");
                                        if (Method.compareToIgnoreCase("post") == 0) {
                                            headers.put(null, String.valueOf(requ[0]) + " " + requ[1] + "?" + RequestParams + " " + requ[2]);
                                        } else {
                                            this.logger.severe("POST Daten bei nem GET aufruf???");
                                        }
                                    } else {
                                        this.logger.severe("POST Fehler postlen soll = " + post_len + " postlen gelesen = " + post_len_read);
                                    }
                                }
                            }
                        }
                        JDSimpleWebserverResponseCreator response = new JDSimpleWebserverResponseCreator();
                        JDSimpleWebserverRequestHandler request = new JDSimpleWebserverRequestHandler(headers, response);
                        OutputStream outputStream = this.Current_Socket.getOutputStream();
                        if (NeedAuth) {
                            if (headers.containsKey("authorization")) {
                                if (AuthUser.equals(headers.get("authorization"))) {
                                    request.handle();
                                } else {
                                    response.setAuth_failed();
                                }
                            } else {
                                response.setAuth_needed();
                            }
                        } else {
                            request.handle();
                        }
                        response.writeToStream(outputStream);
                        outputStream.close();
                    }
                } else {
                    this.logger.severe("kein post oder get header");
                }
                this.Current_Socket.close();
            }
            catch (SocketException e) {
                this.logger.severe("WebInterface: Socket error");
            }
            catch (IOException e) {
                this.logger.severe("WebInterface: I/O Error");
            }
        }
    }
}

