/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.optional.webinterface;

import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import jd.nutils.encoding.Encoding;

public class JDSimpleWebserverResponseCreator {
    private StringBuilder body;
    private byte[] bytes;
    private String contentType = "text/html; charset=UTF-8";
    private StringBuilder headers = new StringBuilder();
    private String filepath = null;
    private long filestart = 0L;
    private long fileend = -1L;
    private long filesize = 0L;
    private boolean range = false;
    private String filename = null;

    public JDSimpleWebserverResponseCreator() {
        this.body = new StringBuilder();
    }

    public void addContent(String content) {
        this.body.append(content);
    }

    public void setAuth_failed() {
        this.headers.append("HTTP/1.1 403 Forbidden\r\n");
        this.body.append("<html><body><h1><p>403 Forbidden</p></h1></body></html>");
    }

    public void setAuth_needed() {
        this.headers.append("HTTP/1.1 401 Unauthorized\r\n");
        this.headers.append("WWW-Authenticate: Basic realm=\"JDownloader\"\r\n");
    }

    public void setBinaryContent(byte[] bytes) {
        this.bytes = bytes;
    }

    public void setFileServe(String path, long start, long end, long filesize, boolean range) {
        this.filepath = path;
        this.filestart = start;
        this.fileend = end == -1L ? filesize : end;
        this.filesize = filesize;
        this.range = range;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setError(Exception e) {
        this.headers.append("HTTP/1.1 500 ");
        this.headers.append(e.getMessage());
        this.headers.append("\r\n");
        this.body.append("<html><body><h1><p>500 Internal server error</p></h1>");
        this.body.append(e.getMessage());
        this.body.append("</body></html>");
    }

    public void setNotFound(String url) {
        this.headers.append("HTTP/1.1 403 Resource not found\r\n");
        this.body.append("<html><body><h1><p>404 Resource not found</p></h1>");
        this.body.append(url);
        this.body.append("</body></html>");
    }

    public void setOk() {
        if (!this.range) {
            this.headers.append("HTTP/1.1 200 OK\r\n");
        } else {
            this.headers.append("HTTP/1.1 206 Partial content\r\n");
        }
        this.headers.append("Connection: close\r\n");
        this.headers.append("Content-Type: ");
        this.headers.append(this.contentType);
        this.headers.append("\r\n");
        try {
            this.headers.append("Content-Length: ");
            if (this.filepath != null) {
                if (!this.range) {
                    this.headers.append(this.filesize);
                    this.headers.append("\r\n");
                } else {
                    if (this.fileend == -1L) {
                        this.fileend = this.filesize;
                    }
                    this.headers.append(Math.max(0L, this.fileend - this.filestart));
                    this.headers.append("\r\n");
                    this.headers.append("Content-Range: bytes " + this.filestart + "-" + this.fileend + "/" + this.filesize);
                    this.headers.append("\r\n");
                }
                if (this.filename != null) {
                    this.headers.append("Content-Disposition: attachment;filename*=UTF-8''" + Encoding.urlEncode((String)this.filename));
                    this.headers.append("\r\n");
                }
                this.headers.append("Accept-Ranges: bytes");
            } else if (this.bytes != null) {
                this.headers.append(this.bytes.length);
            } else {
                this.headers.append(this.body.toString().getBytes("UTF-8").length);
            }
            this.headers.append("\r\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setRedirect() {
        this.headers.append("HTTP/1.1 307 Temporary Redirect\n");
        this.headers.append("Location: /\n");
    }

    public void writeToStream(OutputStream outputStream) throws IOException {
        this.headers.append("\r\n");
        outputStream.write(this.headers.toString().getBytes("UTF-8"));
        if (this.filepath != null) {
            RandomAccessFile raf = null;
            long served = 0L;
            try {
                raf = new RandomAccessFile(this.filepath, "r");
                raf.seek(this.filestart);
                long curpos = this.filestart;
                int toread = 1024;
                int read = 0;
                byte[] buffer = new byte[1024];
                if (this.fileend - curpos < 1024L) {
                    toread = (int)(this.fileend - curpos);
                }
                while ((read = raf.read(buffer, 0, toread)) != -1) {
                    served += (long)read;
                    outputStream.write(buffer);
                    if (this.fileend - (curpos += (long)read) < 1024L) {
                        toread = (int)(this.fileend - curpos);
                    }
                    if (toread == 0 || this.fileend == curpos) break;
                }
                raf.close();
            }
            finally {
                try {
                    raf.close();
                }
                catch (Exception exception) {}
            }
        }
        if (this.bytes != null) {
            outputStream.write(this.bytes);
        } else {
            outputStream.write(this.body.toString().getBytes("UTF-8"));
        }
    }
}

