/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.optional.webinterface;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import jd.OptionalPluginWrapper;
import jd.config.SubConfiguration;
import jd.controlling.DownloadWatchDog;
import jd.controlling.JDLogger;
import jd.controlling.LinkGrabberController;
import jd.controlling.PasswordListController;
import jd.gui.swing.jdgui.views.linkgrabberview.LinkGrabberPanel;
import jd.nutils.Formatter;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.LinkGrabberFilePackage;
import jd.plugins.download.DownloadInterface;
import jd.plugins.optional.webinterface.JDSimpleWebserverResponseCreator;
import jd.plugins.optional.webinterface.JDWebinterface;
import jd.plugins.optional.webinterface.template.Template;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDSimpleWebserverTemplateFileRequestHandler {
    private DecimalFormat f = new DecimalFormat("#0");
    private JDSimpleWebserverResponseCreator response;
    private Vector<Object> v_info = new Vector();
    private LinkGrabberController lgi = LinkGrabberController.getInstance();

    public JDSimpleWebserverTemplateFileRequestHandler(JDSimpleWebserverResponseCreator response) {
        this.response = response;
    }

    private void add_all_info(Template t, HashMap<String, String> requestParameter) {
        Integer package_id = 0;
        if (requestParameter.containsKey("all_info")) {
            String[] ids = requestParameter.get("all_info").toString().split("[+]", 2);
            package_id = Formatter.filterInt((String)ids[0].toString());
            FilePackage fp = (FilePackage)JDUtilities.getController().getPackages().get(package_id);
            this.addEntry("name", fp.getName());
            this.addEntry("comment", fp.getComment());
            this.addEntry("dldirectory", fp.getDownloadDirectory());
            this.addEntry("packagesize", String.valueOf(Formatter.formatReadable((long)fp.getTotalEstimatedPackageSize())) + " " + fp.getTotalEstimatedPackageSize() + " KB");
            this.addEntry("loaded", String.valueOf(Formatter.formatReadable((long)fp.getTotalKBLoaded())) + " " + fp.getTotalKBLoaded() + " KB");
            this.addEntry("links", "");
            DownloadLink next = null;
            int i = 1;
            Iterator it = fp.getDownloadLinkList().iterator();
            while (it.hasNext()) {
                String Single_Status;
                Hashtable<String, Object> h_info = new Hashtable<String, Object>();
                next = (DownloadLink)it.next();
                if (next.isEnabled()) {
                    switch (next.getLinkStatus().getLatestStatus()) {
                        case 2: {
                            Single_Status = "finished";
                            break;
                        }
                        case 1024: {
                            Single_Status = "running";
                            break;
                        }
                        default: {
                            Single_Status = "activated";
                            break;
                        }
                    }
                } else {
                    Single_Status = "deactivated";
                }
                double percent = (double)next.getPercent() / 100.0;
                h_info.put("info_percent", this.f.format(percent));
                h_info.put("download_status", Single_Status);
                h_info.put("info_var", String.valueOf(i) + ". " + next.getName());
                h_info.put("info_value", String.valueOf(Formatter.formatReadable((long)next.getDownloadSpeed())) + "/s " + this.f.format((double)next.getPercent() / 100.0) + " %| " + next.getDownloadCurrent() + "/" + next.getDownloadSize() + " bytes");
                h_info.put("download_id", i - 1);
                this.v_info.addElement(h_info);
                ++i;
            }
            t.setParam("all_infos", this.v_info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add_linkadder_page(Template t, HashMap<String, String> requestParameter) {
        Vector v = new Vector();
        ArrayList arrayList = this.lgi.getPackages();
        synchronized (arrayList) {
            Integer Package_ID = 0;
            while (Package_ID < this.lgi.getPackages().size()) {
                LinkGrabberFilePackage filePackage = (LinkGrabberFilePackage)this.lgi.getPackages().get(Package_ID);
                Hashtable<String, Object> h = new Hashtable<String, Object>();
                h.put("download_name", filePackage.getName());
                h.put("package_id", Package_ID.toString());
                Vector v2 = new Vector();
                Integer Download_ID = 0;
                while (Download_ID < filePackage.getDownloadLinks().size()) {
                    DownloadLink dLink = (DownloadLink)filePackage.getDownloadLinks().get(Download_ID);
                    Hashtable<String, String> h2 = new Hashtable<String, String>();
                    h2.put("package_id", Package_ID.toString());
                    h2.put("download_id", Download_ID.toString());
                    h2.put("download_name", dLink.getName());
                    if (dLink.isAvailabilityStatusChecked() && dLink.isAvailable()) {
                        h2.put("download_status", "online");
                    } else {
                        h2.put("download_status", "offline");
                    }
                    h2.put("download_hoster", dLink.getHost());
                    v2.addElement(h2);
                    Download_ID = Download_ID + 1;
                }
                h.put("downloads", v2);
                v.addElement(h);
                Package_ID = Package_ID + 1;
            }
        }
        t.setParam("pakete", v);
        if (LinkGrabberPanel.getLinkGrabber().isRunning()) {
            t.setParam("message_status", "show");
            t.setParam("message", "LinkGrabber still Running! Please Reload Page in few Secs!");
        }
    }

    private void add_password_list(Template t, HashMap<String, String> requestParameter) {
        StringBuilder pwlist = new StringBuilder();
        ArrayList arrayList = PasswordListController.getInstance().getPasswordList();
        if (arrayList != null) {
            for (String pw : arrayList) {
                if (pw.trim().equals("")) continue;
                pwlist.append(System.getProperty("line.separator")).append(pw);
            }
        }
        t.setParam("password_list", pwlist.toString());
    }

    private void add_single_info(Template t, HashMap<String, String> requestParameter) {
        Integer download_id = 0;
        Integer package_id = 0;
        if (requestParameter.containsKey("single_info")) {
            DownloadInterface dl;
            String Single_Status;
            String[] ids = requestParameter.get("single_info").toString().split("[+]", 2);
            package_id = Formatter.filterInt((String)ids[0].toString());
            download_id = Formatter.filterInt((String)ids[1].toString());
            DownloadLink downloadLink = (DownloadLink)((FilePackage)JDUtilities.getController().getPackages().get(package_id)).getDownloadLinkList().get(download_id);
            this.addEntry("file", String.valueOf(new File(downloadLink.getFileOutput()).getName()) + " @ " + downloadLink.getHost());
            if (downloadLink.getFilePackage() != null && downloadLink.getFilePackage().getPassword() != null) {
                this.addEntry(JDL.L((String)"gui.linkinfo.password", (String)"Passwort"), downloadLink.getFilePackage().getPassword());
            }
            if (downloadLink.getFilePackage() != null && downloadLink.getFilePackage().getComment() != null) {
                this.addEntry(JDL.L((String)"gui.linkinfo.comment", (String)"Kommentar"), downloadLink.getFilePackage().getComment());
            }
            if (downloadLink.getFilePackage() != null) {
                this.addEntry(JDL.L((String)"gui.linkinfo.package", (String)"Packet"), downloadLink.getFilePackage().getName());
            }
            if (downloadLink.getDownloadSize() > 0L) {
                this.addEntry(JDL.L((String)"gui.linkinfo.filesize", (String)"Dateigr\u00f6\u00dfe"), Formatter.formatReadable((long)downloadLink.getDownloadSize()));
            }
            if (downloadLink.isAborted()) {
                this.addEntry(JDL.L((String)"gui.linkinfo.download", (String)"Download"), JDL.L((String)"linkinformation.download.aborted", (String)"Abgebrochen"));
            }
            if (downloadLink.isAvailabilityStatusChecked()) {
                this.addEntry(JDL.L((String)"gui.linkinfo.available", (String)"Verf\u00fcgbar"), downloadLink.isAvailable() ? JDL.L((String)"gui.linkinfo.available.ok", (String)"Datei OK") : JDL.L((String)"linkinformation.available.error", (String)"Fehler!"));
            } else {
                this.addEntry(JDL.L((String)"gui.linkinfo.available", (String)"Verf\u00fcgbar"), JDL.L((String)"gui.linkinfo.available.notchecked", (String)"noch nicht \u00fcberpr\u00fcft"));
            }
            if (downloadLink.getDownloadSpeed() > 0) {
                this.addEntry(JDL.L((String)"gui.linkinfo.speed", (String)"Geschwindigkeit"), String.valueOf(Formatter.formatReadable((long)downloadLink.getDownloadSpeed())) + " /s");
            }
            if (downloadLink.getFileOutput() != null) {
                this.addEntry(JDL.L((String)"gui.linkinfo.saveto", (String)"Speichern in"), downloadLink.getFileOutput());
            }
            if (DownloadWatchDog.getInstance().getRemainingTempUnavailWaittime(downloadLink.getHost()) > 0L) {
                this.addEntry(JDL.L((String)"gui.linkinfo.waittime", (String)"Wartezeit"), String.valueOf(DownloadWatchDog.getInstance().getRemainingTempUnavailWaittime(downloadLink.getHost()) / 1000L) + " sek");
            } else if (DownloadWatchDog.getInstance().getRemainingIPBlockWaittime(downloadLink.getHost()) > 0L) {
                this.addEntry(JDL.L((String)"gui.linkinfo.waittime", (String)"Wartezeit"), String.valueOf(DownloadWatchDog.getInstance().getRemainingIPBlockWaittime(downloadLink.getHost()) / 1000L) + " sek");
            }
            if (downloadLink.getLinkStatus().isPluginActive()) {
                this.addEntry(JDL.L((String)"gui.linkinfo.download", (String)"Download"), JDL.L((String)"gui.linkinfo.download.underway", (String)" ist in Bearbeitung"));
            } else {
                this.addEntry(JDL.L((String)"gui.linkinfo.download", (String)"Download"), JDL.L((String)"gui.linkinfo.download.notunderway", (String)" ist nicht in Bearbeitung"));
            }
            if (!downloadLink.isEnabled()) {
                this.addEntry(JDL.L((String)"gui.linkinfo.download", (String)"Download"), JDL.L((String)"gui.linkinfo.download.deactivated", (String)" ist deaktiviert"));
            } else {
                this.addEntry(JDL.L((String)"gui.linkinfo.download", (String)"Download"), JDL.L((String)"gui.linkinfo.download.activated", (String)" ist aktiviert"));
            }
            this.addEntry(JDL.L((String)"gui.linkinfo.download", (String)"Status"), downloadLink.getLinkStatus().getStatusString());
            if (downloadLink.isEnabled()) {
                switch (downloadLink.getLinkStatus().getLatestStatus()) {
                    case 2: {
                        Single_Status = "finished";
                        break;
                    }
                    case 1024: {
                        Single_Status = "running";
                        break;
                    }
                    default: {
                        Single_Status = "activated";
                        break;
                    }
                }
            } else {
                Single_Status = "deactivated";
            }
            if (downloadLink.getLinkStatus().isPluginActive() && (dl = downloadLink.getDownloadInstance()) != null) {
                this.addEntry(JDL.L((String)"linkinformation.download.chunks.label", (String)"Chunks"), "");
                int i = 1;
                Iterator it = dl.getChunks().iterator();
                while (it.hasNext()) {
                    Hashtable<String, Object> h_info = new Hashtable<String, Object>();
                    DownloadInterface.Chunk next = (DownloadInterface.Chunk)it.next();
                    double percent = (double)next.getPercent() / 100.0;
                    h_info.put("download_status", Single_Status);
                    h_info.put("info_var", String.valueOf(JDL.L((String)"download.chunks.connection", (String)"Verbindung")) + " " + i);
                    h_info.put("info_value", String.valueOf(Formatter.formatReadable((long)((int)next.getBytesPerSecond()))) + "/s " + this.f.format((double)next.getPercent() / 100.0) + " %");
                    h_info.put("info_percent", this.f.format(percent));
                    h_info.put("download_id", i - 1);
                    this.v_info.addElement(h_info);
                    ++i;
                }
            }
            t.setParam("single_infos", this.v_info);
        }
    }

    private void add_status_page(Template t, HashMap<String, String> requestParameter) {
        Vector v = new Vector();
        Double percent = 0.0;
        Integer Package_ID = 0;
        while (Package_ID < JDUtilities.getController().getPackages().size()) {
            FilePackage filePackage = (FilePackage)JDUtilities.getController().getPackages().get(Package_ID);
            Hashtable<String, Object> h = new Hashtable<String, Object>();
            int[] status = new int[4];
            h.put("download_name", filePackage.getName());
            String value = "";
            percent = filePackage.getPercent();
            h.put("download_status_percent", this.f.format(percent));
            if (filePackage.getLinksInProgress() > 0) {
                value = String.valueOf(filePackage.getLinksInProgress()) + "/" + filePackage.size() + " " + JDL.L((String)"gui.treetable.packagestatus.links_active", (String)"aktiv");
            }
            if (filePackage.getTotalDownloadSpeed() > 0L) {
                value = "[" + filePackage.getLinksInProgress() + "/" + filePackage.size() + "] " + "ETA " + Formatter.formatSeconds((long)filePackage.getETA()) + " @ " + Formatter.formatReadable((long)filePackage.getTotalDownloadSpeed()) + "/s";
            }
            h.put("package_id", Package_ID.toString());
            h.put("download_hoster", value);
            h.put("download_status_text", String.valueOf(this.f.format(percent)) + " % (" + Formatter.formatReadable((long)filePackage.getTotalKBLoaded()) + " / " + Formatter.formatReadable((long)filePackage.getTotalEstimatedPackageSize()) + ")");
            Vector v2 = new Vector();
            Integer Download_ID = 0;
            while (Download_ID < filePackage.getDownloadLinkList().size()) {
                DownloadLink dLink = (DownloadLink)filePackage.getDownloadLinkList().get(Download_ID);
                percent = (double)dLink.getDownloadCurrent() * 100.0 / (double)Math.max(1L, dLink.getDownloadSize());
                Hashtable<String, String> h2 = new Hashtable<String, String>();
                h2.put("download_status_percent", this.f.format(percent));
                h2.put("package_id", Package_ID.toString());
                h2.put("download_id", Download_ID.toString());
                h2.put("download_name", dLink.getName());
                h2.put("download_hoster", dLink.getHost());
                if (dLink.isAvailabilityStatusChecked() && !dLink.isAvailable()) {
                    status[0] = 1;
                    h2.put("download_status", "offline");
                } else if (dLink.isEnabled()) {
                    switch (dLink.getLinkStatus().getLatestStatus()) {
                        case 32: {
                            status[0] = 1;
                            h2.put("download_status", "offline");
                            break;
                        }
                        case 2: {
                            status[3] = 1;
                            h2.put("download_status", "finished");
                            break;
                        }
                        case 1024: {
                            status[2] = 1;
                            h2.put("download_status", "running");
                            break;
                        }
                        default: {
                            status[1] = 1;
                            h2.put("download_status", "activated");
                            break;
                        }
                    }
                } else {
                    status[0] = 1;
                    h2.put("download_status", "deactivated");
                }
                h2.put("download_status_text", String.valueOf(this.f.format(percent)) + "% " + dLink.getLinkStatus().getStatusString());
                v2.addElement(h2);
                Download_ID = Download_ID + 1;
            }
            if (status[3] == 1 && status[2] == 0 && status[1] == 0 && status[0] == 0) {
                h.put("download_status", "finished");
            } else if (status[2] == 1) {
                h.put("download_status", "running");
            } else if (status[1] == 1) {
                h.put("download_status", "activated");
            } else if (status[0] == 1) {
                h.put("download_status", "deactivated");
            }
            h.put("downloads", v2);
            v.addElement(h);
            Package_ID = Package_ID + 1;
        }
        t.setParam("config_current_speed", JDUtilities.getController().getSpeedMeter() / 1024);
        t.setParam("config_max_downloads", SubConfiguration.getConfig((String)"DOWNLOAD").getIntegerProperty("DOWNLOAD_MAX_SIMULTAN", 2));
        t.setParam("config_max_speed", SubConfiguration.getConfig((String)"DOWNLOAD").getIntegerProperty("DOWNLOAD_MAX_SPEED_V2", 0));
        if (JDUtilities.getConfiguration().getBooleanProperty("ALLOW_RECONNECT", true).booleanValue()) {
            t.setParam("config_autoreconnect", "checked");
        } else {
            t.setParam("config_autoreconnect", "");
        }
        if (DownloadWatchDog.getInstance().getDownloadStatus() == DownloadWatchDog.STATE.RUNNING) {
            t.setParam("config_startstopbutton", "stop");
        } else {
            t.setParam("config_startstopbutton", "start");
        }
        t.setParam("pakete", v);
    }

    private void addEntry(String var, String value) {
        Hashtable<String, String> h_info = new Hashtable<String, String>();
        h_info.put("info_var", var);
        h_info.put("info_value", value);
        this.v_info.addElement(h_info);
    }

    public void handleRequest(String url, HashMap<String, String> requestParameter) {
        try {
            Template t = new Template(JDUtilities.getResourceFile((String)("plugins/webinterface/" + url)).getAbsolutePath());
            t.setParam("webinterface_version", JDWebinterface.instance.getPluginID());
            t.setParam("page_refresh", JDWebinterface.getRefreshRate());
            boolean hasUnrar = false;
            OptionalPluginWrapper wrapper = JDUtilities.getOptionalPlugin((String)"unrar");
            if (wrapper != null && wrapper.isEnabled()) {
                hasUnrar = true;
            }
            t.setParam("unrar_available", hasUnrar ? "unrarAvailable" : "unrarUnavailable");
            if (url.startsWith("single_info.tmpl")) {
                this.add_single_info(t, requestParameter);
            }
            if (url.startsWith("all_info.tmpl")) {
                this.add_all_info(t, requestParameter);
            }
            if (url.startsWith("index.tmpl")) {
                this.add_status_page(t, requestParameter);
            }
            if (url.startsWith("passwd.tmpl")) {
                this.add_password_list(t, requestParameter);
            }
            if (url.startsWith("link_adder.tmpl")) {
                this.add_linkadder_page(t, requestParameter);
            }
            this.response.addContent(t.output());
            this.response.setOk();
        }
        catch (FileNotFoundException e) {
            JDLogger.exception((Throwable)e);
        }
        catch (IllegalStateException e) {
            JDLogger.exception((Throwable)e);
        }
        catch (IOException e) {
            JDLogger.exception((Throwable)e);
        }
    }
}

