/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.optional.webinterface.template.Tmpl.Element;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import jd.plugins.optional.webinterface.template.Tmpl.Element.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Loop
extends Element {
    private Vector<?> control_val = null;
    private Vector<Object> data;
    private boolean global_vars = false;
    private boolean loop_context_vars = false;

    public Loop(String name) {
        this.type = "loop";
        this.name = name;
        this.data = new Vector();
    }

    public Loop(String name, boolean loop_context_vars) {
        this(name);
        this.loop_context_vars = loop_context_vars;
    }

    public Loop(String name, boolean loop_context_vars, boolean global_vars) {
        this(name);
        this.loop_context_vars = loop_context_vars;
        this.global_vars = global_vars;
    }

    @Override
    public void add(Element node) {
        this.data.addElement(node);
    }

    @Override
    public void add(String text) {
        this.data.addElement(text);
    }

    @Override
    public String parse(Hashtable<?, ?> p) {
        if (!p.containsKey(this.name)) {
            this.control_val = null;
        } else {
            Object o = p.get(this.name);
            if (!o.getClass().getName().endsWith(".Vector") && !o.getClass().getName().endsWith(".List")) {
                throw new ClassCastException("Attempt to set <tmpl_loop> with a non-list.  tmpl_loop=" + this.name);
            }
            this.setControlValue((Vector)p.get(this.name));
        }
        if (this.control_val == null) {
            return "";
        }
        StringBuilder output = new StringBuilder();
        Enumeration<?> iterator = this.control_val.elements();
        boolean first = true;
        boolean last = false;
        boolean inner = false;
        boolean odd = true;
        int counter = 1;
        while (iterator.hasMoreElements()) {
            Hashtable<Object, Object> params = (Hashtable<Object, Object>)iterator.nextElement();
            if (params == null) {
                params = new Hashtable<Object, Object>();
            }
            if (this.global_vars) {
                Enumeration<?> e = p.keys();
                while (e.hasMoreElements()) {
                    Object key = e.nextElement();
                    if (params.containsKey(key)) continue;
                    params.put(key, p.get(key));
                }
            }
            if (this.loop_context_vars) {
                if (!iterator.hasMoreElements()) {
                    last = true;
                }
                inner = !first && !last;
                params.put("__FIRST__", first ? "1" : "");
                params.put("__LAST__", last ? "1" : "");
                params.put("__ODD__", odd ? "1" : "");
                params.put("__INNER__", inner ? "1" : "");
                params.put("__COUNTER__", "" + counter++);
            }
            Enumeration<Object> de = this.data.elements();
            while (de.hasMoreElements()) {
                Object e = de.nextElement();
                if (e.getClass().getName().indexOf("String") > -1) {
                    output.append((String)e);
                    continue;
                }
                output.append(((Element)e).parse(params));
            }
            first = false;
            boolean bl = odd = !odd;
        }
        return output.toString();
    }

    private Vector<?> process_var(Vector<?> control_val) throws IllegalArgumentException {
        String control_class = "";
        if (control_val == null) {
            return null;
        }
        control_class = control_val.getClass().getName();
        if (control_class.indexOf("Vector") > -1) {
            if (control_val.isEmpty()) {
                return null;
            }
        } else {
            throw new IllegalArgumentException("Unrecognised type");
        }
        return control_val;
    }

    public void setControlValue(Vector<?> control_val) throws IllegalArgumentException {
        this.control_val = this.process_var(control_val);
    }

    @Override
    public String typeOfParam(String param) throws NoSuchElementException {
        for (Object o : this.data) {
            if (o.getClass().getName().endsWith(".String") || !((Element)o).Name().equals(param)) continue;
            return ((Element)o).Type();
        }
        throw new NoSuchElementException(param);
    }
}

