/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.optional.webinterface.template.Tmpl.Element;

import java.util.Date;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import jd.plugins.optional.webinterface.template.Tmpl.Element.Element;
import jd.plugins.optional.webinterface.template.Tmpl.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Var
extends Element {
    public static final int ESCAPE_HTML = 2;
    public static final int ESCAPE_NONE = 0;
    public static final int ESCAPE_QUOTE = 4;
    public static final int ESCAPE_URL = 1;
    private String default_value = null;
    private int escape = 0;

    public Var(String name, boolean escape) throws IllegalArgumentException {
        this(name, escape ? 2 : 0);
    }

    public Var(String name, int escape) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("tmpl_var must have a name");
        }
        this.type = "var";
        this.name = name;
        this.escape = escape;
    }

    public Var(String name, int escape, Object default_value) throws IllegalArgumentException {
        this(name, escape);
        this.default_value = this.stringify(default_value);
    }

    public Var(String name, String escape) throws IllegalArgumentException {
        this(name, escape, null);
    }

    public Var(String name, String escape, Object default_value) throws IllegalArgumentException {
        this(name, 0, default_value);
        if (escape.equalsIgnoreCase("html")) {
            this.escape = 2;
        } else if (escape.equalsIgnoreCase("url")) {
            this.escape = 1;
        } else if (escape.equalsIgnoreCase("quote")) {
            this.escape = 4;
        }
    }

    @Override
    public String parse(Hashtable<?, ?> params) {
        String value = null;
        value = params.containsKey(this.name) ? this.stringify(params.get(this.name)) : this.default_value;
        if (value == null) {
            return "";
        }
        if (this.escape == 2) {
            return Util.escapeHTML(value);
        }
        if (this.escape == 1) {
            return Util.escapeURL(value);
        }
        if (this.escape == 4) {
            return Util.escapeQuote(value);
        }
        return value;
    }

    private String stringify(Object o) {
        if (o == null) {
            return null;
        }
        String cname = o.getClass().getName();
        if (cname.endsWith(".String")) {
            return (String)o;
        }
        if (cname.endsWith(".Integer")) {
            return ((Integer)o).toString();
        }
        if (cname.endsWith(".Boolean")) {
            return ((Boolean)o).toString();
        }
        if (cname.endsWith(".Date")) {
            return ((Date)o).toString();
        }
        if (cname.endsWith(".Vector")) {
            throw new ClassCastException("Attempt to set <tmpl_var> with a non-scalar. Var name=" + this.name);
        }
        throw new ClassCastException("Unknown object type: " + cname);
    }

    @Override
    public String typeOfParam(String param) throws NoSuchElementException {
        throw new NoSuchElementException(param);
    }
}

