/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.optional;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JComboBox;
import jd.PluginWrapper;
import jd.config.ConfigEntry;
import jd.config.Property;
import jd.config.SubConfiguration;
import jd.controlling.JDLogger;
import jd.controlling.SingleDownloadController;
import jd.event.ControlEvent;
import jd.event.ControlListener;
import jd.gui.swing.components.JDTextArea;
import jd.gui.swing.jdgui.menu.MenuAction;
import jd.gui.swing.jdgui.settings.GUIConfigEntry;
import jd.nutils.io.JDIO;
import jd.plugins.DownloadLink;
import jd.plugins.OptionalPlugin;
import jd.plugins.PluginForHost;
import jd.plugins.PluginOptional;
import jd.utils.JDUtilities;
import jd.utils.Replacer;
import jd.utils.locale.JDL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@OptionalPlugin(rev="$Revision: 9413 $", id="infofilewriter", interfaceversion=5)
public class JDInfoFileWriter
extends PluginOptional
implements ControlListener {
    private static final String FILENAME_DEFAULT = "%LAST_FINISHED_PACKAGE.DOWNLOAD_DIRECTORY%/%LAST_FINISHED_PACKAGE.PACKAGENAME%.info";
    private static final String INFO_STRING_DEFAULT = "Password: %LAST_FINISHED_PACKAGE.PASSWORD%\r\n%LAST_FINISHED_PACKAGE.FILELIST%\r\nFinalized %SYSTEM.DATE% to %SYSTEM.TIME% Clock";
    private static final String PARAM_FILENAME = "FILENAME";
    private static final String PARAM_INFO_STRING = "INFO_STRING";
    private static final long serialVersionUID = 7680205811276541375L;
    private ConfigEntry cmbVars;
    private ConfigEntry txtInfo;
    private SubConfiguration subConfig = SubConfiguration.getConfig((String)"JDInfoFileWriter");

    public JDInfoFileWriter(PluginWrapper wrapper) {
        super(wrapper);
        this.initConfig();
    }

    public void controlEvent(ControlEvent event) {
        DownloadLink lastDownloadFinished;
        super.controlEvent(event);
        if (event.getID() == 4 && event.getSource() instanceof PluginForHost && (lastDownloadFinished = ((SingleDownloadController)event.getParameter()).getDownloadLink()).getFilePackage().getRemainingLinks() == 0) {
            this.writeInfoFile();
        }
    }

    public ArrayList<MenuAction> createMenuitems() {
        return null;
    }

    public boolean initAddon() {
        JDUtilities.getController().addControlListener((ControlListener)this);
        return true;
    }

    public void initConfig() {
        this.cmbVars = new ConfigEntry(1, (Property)this.subConfig, "VARS", (Object[])Replacer.getKeyList(), JDL.L((String)"plugins.optional.infoFileWriter.variables", (String)"Available variables"));
        this.config.addEntry(this.cmbVars);
        this.config.addEntry(new ConfigEntry(2, (ActionListener)((Object)this), JDL.L((String)"plugins.optional.infoFileWriter.insertKey.short", (String)"Insert"), JDL.L((String)"plugins.optional.infoFileWriter.insertKey", (String)"Insert selected Key into the Content"), null));
        this.config.addEntry(new ConfigEntry(0, (Property)this.subConfig, PARAM_FILENAME, JDL.L((String)"plugins.optional.infoFileWriter.filename", (String)"Filename:")).setDefaultValue((Object)FILENAME_DEFAULT));
        this.txtInfo = new ConfigEntry(10, (Property)this.subConfig, PARAM_INFO_STRING, JDL.L((String)"plugins.optional.infoFileWriter.content", (String)"Content:")).setDefaultValue((Object)INFO_STRING_DEFAULT);
        this.config.addEntry(this.txtInfo);
    }

    public void actionPerformed(ActionEvent e) {
        JComboBox cmb = (JComboBox)((GUIConfigEntry)this.cmbVars.getGuiListener()).getInput()[0];
        if (cmb.getSelectedIndex() < 0) {
            return;
        }
        JDTextArea txt = (JDTextArea)((GUIConfigEntry)this.txtInfo.getGuiListener()).getInput()[0];
        txt.insert("%" + Replacer.getKey((int)cmb.getSelectedIndex()) + "%", txt.getCaretPosition());
    }

    public void onExit() {
        JDUtilities.getController().removeControlListener((ControlListener)this);
    }

    private void writeInfoFile() {
        String content = Replacer.insertVariables((String)this.subConfig.getStringProperty(PARAM_INFO_STRING, INFO_STRING_DEFAULT));
        String filename = Replacer.insertVariables((String)this.subConfig.getStringProperty(PARAM_FILENAME, FILENAME_DEFAULT));
        File dest = new File(filename);
        try {
            if (dest.createNewFile() && dest.canWrite()) {
                JDIO.writeLocalFile((File)dest, (String)content);
                logger.severe("JDInfoFileWriter: info file " + dest.getAbsolutePath() + " successfully created");
            } else {
                logger.severe("JDInfoFileWriter: can not write to: " + dest.getAbsolutePath());
            }
        }
        catch (Exception e) {
            JDLogger.exception((Throwable)e);
            logger.severe("JDInfoFileWriter: can not write to: " + dest.getAbsolutePath());
        }
    }
}

