/*
 * Decompiled with CFR 0.152.
 */
package jd.nutils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.logging.Logger;
import jd.nutils.DynByteBuffer;
import jd.nutils.OSDetector;
import jd.nutils.ProcessListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Executer
extends Thread
implements Runnable {
    public static final String CODEPAGE = OSDetector.isWindows() ? "ISO-8859-1" : "UTF-8";
    private boolean debug = true;
    private Logger logger;
    private String codepage = CODEPAGE;
    public static int LISTENER_ERRORSTREAM = 1;
    public static int LISTENER_STDSTREAM = 2;
    private String command;
    private ArrayList<String> parameter;
    private String runIn;
    private DynByteBuffer inputStreamBuffer;
    private DynByteBuffer errorStreamBuffer;
    private ArrayList<ProcessListener> listener = new ArrayList();
    private ArrayList<ProcessListener> elistener = new ArrayList();
    private int waitTimeout = 60;
    private int exitValue = -1;
    private boolean gotInterrupted = false;
    private Process process;
    private StreamObserver sbeObserver;
    private StreamObserver sboObserver;
    private OutputStream outputStream = null;
    private Exception exception = null;

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String getCodepage() {
        return this.codepage;
    }

    public void setCodepage(String codepage) {
        this.codepage = codepage;
    }

    public Executer(String command) {
        super("Executer: " + command);
        this.command = command;
        this.parameter = new ArrayList();
        this.inputStreamBuffer = new DynByteBuffer(4096);
        this.errorStreamBuffer = new DynByteBuffer(4096);
    }

    public void addParameter(String par) {
        this.parameter.add(par);
    }

    public void addParameters(String[] par) {
        if (par == null) {
            return;
        }
        String[] stringArray = par;
        int n = par.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            this.parameter.add(p);
            ++n2;
        }
    }

    public String getCommand() {
        return this.command;
    }

    public String getErrorStream() {
        return this.errorStreamBuffer.toString(this.codepage);
    }

    public ArrayList<String> getParameter() {
        return this.parameter;
    }

    public String getRunin() {
        return this.runIn;
    }

    public String getOutputStream() {
        return this.inputStreamBuffer.toString(this.codepage);
    }

    public int getWaitTimeout() {
        return this.waitTimeout;
    }

    @Override
    public void run() {
        if (this.command == null || this.command.trim().length() == 0) {
            if (this.logger != null) {
                this.logger.severe("Execute Parameter error: No Command");
            }
            return;
        }
        ArrayList<String> params = new ArrayList<String>();
        params.add(this.command);
        params.addAll(this.parameter);
        if (this.isDebug()) {
            StringBuilder out = new StringBuilder();
            for (String p : params) {
                out.append(p);
                out.append(' ');
            }
            if (this.logger != null) {
                this.logger.info("Execute: " + out + " in " + this.runIn);
            }
        }
        ProcessBuilder pb = new ProcessBuilder(params.toArray(new String[0]));
        if (this.runIn != null && this.runIn.length() > 0) {
            if (new File(this.runIn).exists()) {
                pb.directory(new File(this.runIn));
            } else if (new File((String)params.get(0)).getParentFile().exists()) {
                pb.directory(new File((String)params.get(0)).getParentFile());
            } else if (this.logger != null) {
                this.logger.severe("Working directory " + this.runIn + " does not exist!");
            }
        }
        try {
            this.process = pb.start();
            if (this.waitTimeout == 0) {
                return;
            }
            this.outputStream = this.process.getOutputStream();
            this.sbeObserver = new StreamObserver(this.process.getErrorStream(), this.errorStreamBuffer);
            this.sbeObserver.setName(String.valueOf(this.getName()) + " ERRstreamobserver");
            this.sboObserver = new StreamObserver(this.process.getInputStream(), this.inputStreamBuffer);
            this.sboObserver.setName(String.valueOf(this.getName()) + " STDstreamobserver");
            this.sbeObserver.start();
            this.sboObserver.start();
            if (this.waitTimeout > 0) {
                Thread timeoutThread = new Thread(){

                    public void run() {
                        try {
                            Thread.sleep(Executer.this.waitTimeout * 1000);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        Executer.this.interrupt();
                    }
                };
                timeoutThread.start();
            }
            try {
                this.process.waitFor();
                this.exitValue = this.process.exitValue();
            }
            catch (InterruptedException e1) {
                this.process.destroy();
                this.gotInterrupted = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.logger != null) {
                this.logger.finer("Process returned");
            }
            if (this.sboObserver != null && this.sboObserver.isIdle()) {
                if (this.logger != null) {
                    this.logger.finer("sbo idle - interrupt");
                }
                this.sboObserver.requestInterrupt();
            }
            if (this.sbeObserver != null && this.sbeObserver.isIdle()) {
                if (this.logger != null) {
                    this.logger.finer("sbe idle - interrupt");
                }
                this.sbeObserver.requestInterrupt();
            }
            long returnTime = System.currentTimeMillis();
            Executer.interrupted();
            while (this.sbeObserver != null && this.sbeObserver.isAlive() || this.sboObserver != null && this.sboObserver.isAlive()) {
                Thread.sleep(50L);
                if (System.currentTimeMillis() - returnTime <= 60000L) continue;
                if (this.logger != null) {
                    this.logger.severe("Executer Error. REPORT THIS BUG INCL. THIS LOG to jd support");
                }
                this.sboObserver.requestInterrupt();
                this.sbeObserver.requestInterrupt();
                break;
            }
            if (this.logger != null) {
                this.logger.finer("Stream observer closed");
            }
        }
        catch (IOException e1) {
            this.exception = e1;
            return;
        }
        catch (InterruptedException e) {
            this.exception = e;
        }
    }

    public Exception getException() {
        return this.exception;
    }

    public Process getProcess() {
        return this.process;
    }

    @Override
    public void interrupt() {
        this.gotInterrupted = true;
        super.interrupt();
        if (this.sbeObserver != null) {
            this.sbeObserver.requestInterrupt();
        }
        if (this.sboObserver != null) {
            this.sboObserver.requestInterrupt();
        }
        this.process.destroy();
    }

    public DynByteBuffer getInputStreamBuffer() {
        return this.inputStreamBuffer;
    }

    public void writetoOutputStream(String data) {
        if (data == null || data.length() == 0) {
            data = "";
        }
        try {
            this.outputStream.write(data.getBytes());
            this.outputStream.write("\n".getBytes());
            if (this.isDebug()) {
                System.out.println("Out>" + data);
            }
            this.outputStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public DynByteBuffer getErrorStreamBuffer() {
        return this.errorStreamBuffer;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public void setParameter(ArrayList<String> parameter) {
        this.parameter = parameter;
    }

    public void setRunin(String runin) {
        this.runIn = runin;
    }

    public void setWaitTimeout(int waitTimeout) {
        this.waitTimeout = waitTimeout;
    }

    public void waitTimeout() {
        while (this.isAlive()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public int getExitValue() {
        return this.exitValue;
    }

    public boolean gotInterrupted() {
        return this.gotInterrupted;
    }

    public void addProcessListener(ProcessListener listener, int flag) {
        this.removeProcessListener(listener, flag);
        if ((flag & LISTENER_STDSTREAM) > 0) {
            this.listener.add(listener);
        }
        if ((flag & LISTENER_ERRORSTREAM) > 0) {
            this.elistener.add(listener);
        }
    }

    private void fireEvent(String line, DynByteBuffer sb, int flag) {
        if ((flag & LISTENER_STDSTREAM) > 0) {
            for (ProcessListener listener : this.listener) {
                listener.onProcess(this, line, sb);
            }
        }
        if ((flag & LISTENER_ERRORSTREAM) > 0) {
            for (ProcessListener elistener : this.elistener) {
                elistener.onProcess(this, line, sb);
            }
        }
    }

    private void fireEvent(DynByteBuffer buffer, int read, int flag) {
        if (this.isInterrupted()) {
            return;
        }
        if ((flag & LISTENER_STDSTREAM) > 0) {
            for (ProcessListener listener : this.listener) {
                listener.onBufferChanged(this, buffer, read);
            }
        }
        if ((flag & LISTENER_ERRORSTREAM) > 0) {
            for (ProcessListener elistener : this.elistener) {
                elistener.onBufferChanged(this, buffer, read);
            }
        }
    }

    public void removeProcessListener(ProcessListener listener, int flag) {
        if ((flag & LISTENER_STDSTREAM) > 0) {
            this.listener.remove(listener);
        }
        if ((flag & LISTENER_ERRORSTREAM) > 0) {
            this.elistener.remove(listener);
        }
    }

    static /* synthetic */ String access$2(Executer executer) {
        return executer.codepage;
    }

    static /* synthetic */ void access$3(Executer executer, String string, DynByteBuffer dynByteBuffer, int n) {
        executer.fireEvent(string, dynByteBuffer, n);
    }

    class StreamObserver
    extends Thread
    implements Runnable {
        private BufferedInputStream reader;
        private DynByteBuffer dynbuf;
        private boolean started;
        private boolean idle = true;
        private boolean endOfFileReceived = false;
        private InputStream stream;
        private boolean isClosed = false;
        private final Object LOCK = new Object();

        public StreamObserver(InputStream stream, DynByteBuffer buffer) {
            this.stream = stream;
            this.reader = new BufferedInputStream(stream);
            this.dynbuf = buffer;
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[WHILELOOP]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private int readLine() throws IOException, InterruptedException {
            int i = 0;
            byte[] buffer = new byte[1];
            this.idle = false;
            while (true) {
                if (this.isInterrupted()) {
                    throw new InterruptedException();
                }
                int read = this.reader.read(buffer);
                if (read < 0) {
                    this.endOfFileReceived = true;
                    return i;
                }
                if (read > 0) {
                    i += read;
                    this.dynbuf.put(buffer, read);
                    if (buffer[0] == 8 || buffer[0] == 13 || buffer[0] == 10) {
                        return i;
                    }
                    Executer.this.fireEvent(this.dynbuf, read, this == Executer.this.sbeObserver ? LISTENER_ERRORSTREAM : LISTENER_STDSTREAM);
                    continue;
                }
                Thread.sleep(100L);
            }
        }

        public boolean isStarted() {
            return this.started;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestInterrupt() {
            try {
                Object object = this.LOCK;
                synchronized (object) {
                    if (!this.isClosed && this.idle && this.reader.available() > 0) {
                        return;
                    }
                }
                this.isClosed = true;
                super.interrupt();
                this.stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public boolean isIdle() {
            return this.idle;
        }
    }
}

